/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.image;

import de.p2tools.p2lib.image.ImgFile;
import de.p2tools.p2lib.tools.log.P2Log;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.text.NumberFormat;
import java.util.Locale;

public class ImgTools {
    public static long JPEG_MAX_DIMENSION = 65500L;

    public static String fileType(File file) {
        return ImgTools.fileType(file.getName());
    }

    public static String fileType(String file) {
        String fileName = file;
        String suffix = "";
        int i = fileName.lastIndexOf(46);
        if (i > 0 && i < fileName.length() - 1) {
            suffix = fileName.substring(i + 1).toLowerCase();
        }
        if (suffix.equals("jpeg") || suffix.equals("jpg")) {
            return "jpg";
        }
        if (suffix.equals("png")) {
            return "png";
        }
        return "";
    }

    public static Color getColor(BufferedImage img) {
        WritableRaster raster = img.getRaster();
        long r = 0L;
        long g = 0L;
        long b = 0L;
        long count = 0L;
        try {
            for (int x = raster.getMinX(); x < raster.getMinX() + raster.getWidth(); ++x) {
                for (int y = raster.getMinY(); y < raster.getMinY() + raster.getHeight(); ++y) {
                    r += (long)raster.getSample(x, y, 0);
                    g += (long)raster.getSample(x, y, 1);
                    b += (long)raster.getSample(x, y, 2);
                    ++count;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int rr = (int)(r / count);
        int gg = (int)(g / count);
        int bb = (int)(b / count);
        Color ret = new Color(rr, gg, bb);
        return ret;
    }

    public static int getGrayValue(BufferedImage img) {
        Color c = ImgTools.getColor(img);
        long gray = (c.getRed() + c.getGreen() + c.getBlue()) / 3;
        return (int)gray;
    }

    public static void changeToGrayscale(BufferedImage img) {
        int width = img.getWidth();
        int height = img.getHeight();
        try {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int p = img.getRGB(x, y);
                    int a = p >> 24 & 0xFF;
                    int r = p >> 16 & 0xFF;
                    int g = p >> 8 & 0xFF;
                    int b = p & 0xFF;
                    int avg = (r + g + b) / 3;
                    p = a << 24 | avg << 16 | avg << 8 | avg;
                    img.setRGB(x, y, p);
                }
            }
        }
        catch (Exception e) {
            P2Log.errorLog(698741254, e, ImgFile.class.toString());
        }
    }

    public static BufferedImage scaleBufferedImage(BufferedImage src, int w, int h) {
        Image scaledImage = src.getScaledInstance(w, h, 4);
        BufferedImage outImg = new BufferedImage(w, h, 1);
        Graphics2D g = outImg.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.drawImage(scaledImage, 0, 0, null);
        g.dispose();
        return outImg;
    }

    public static long getImgFileSize(int pixelW, int pixelH) {
        long SIZE = 170L;
        long sumPixel = (long)pixelW * (long)pixelH;
        long fSize = 170L * sumPixel / 1000000L;
        return fSize;
    }

    public static String getImgFileSizeStr(int pixelW, int pixelH) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.GERMANY);
        long fSize = ImgTools.getImgFileSize(pixelW, pixelH);
        String fileSize = numberFormat.format(fSize) + " KByte";
        if (fSize > 1024L) {
            fileSize = numberFormat.format(fSize /= 1024L) + " MByte";
        }
        if (fSize > 1024L) {
            fileSize = numberFormat.format(fSize /= 1024L) + " GByte";
        }
        return fileSize;
    }
}

