/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.image;

import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.image.ImgTools;
import de.p2tools.p2lib.tools.log.P2Log;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import javafx.application.Platform;
import javafx.scene.paint.Color;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;

public class ImgFile {
    public static final String IMAGE_FORMAT_JPG = "jpg";
    public static final String IMAGE_FORMAT_PNG = "png";

    public static final BufferedImage cloneImage(BufferedImage image) {
        BufferedImage clone = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
        Graphics2D g2d = clone.createGraphics();
        g2d.drawImage((Image)image, 0, 0, null);
        g2d.dispose();
        return clone;
    }

    public static BufferedImage getBufferedImage(int destWidth, int destHeight, BufferedImage image) {
        BufferedImage imgOut = new BufferedImage(destWidth, destHeight, 1);
        image = ImgTools.scaleBufferedImage(image, destWidth, destHeight);
        Graphics2D g2d = imgOut.createGraphics();
        g2d.drawImage((Image)image, 0, 0, null);
        g2d.dispose();
        return imgOut;
    }

    public static BufferedImage getBufferedImage(int destWidth, int destHeight, String colorStr) {
        java.awt.Color bgColor;
        try {
            Color fx = Color.web(colorStr);
            bgColor = new java.awt.Color((float)fx.getRed(), (float)fx.getGreen(), (float)fx.getBlue(), (float)fx.getOpacity());
        }
        catch (Exception ex) {
            bgColor = java.awt.Color.BLACK;
        }
        BufferedImage imgOut = new BufferedImage(destWidth, destHeight, 1);
        Graphics2D g = imgOut.createGraphics();
        g.setColor(bgColor);
        g.fillRect(0, 0, imgOut.getWidth(), imgOut.getHeight());
        g.dispose();
        return imgOut;
    }

    public static BufferedImage getBufferedImage(int destWidth, int destHeight) {
        BufferedImage imgOut = new BufferedImage(destWidth, destHeight, 1);
        return imgOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getBufferedImage(File source2) {
        BufferedImage bufferedImage = null;
        ImageReader imageReader = ImgFile.getImageReader(source2);
        if (imageReader == null) {
            return bufferedImage;
        }
        try {
            bufferedImage = imageReader.read(0);
        }
        catch (Exception ex) {
            P2Log.errorLog(461214587, ex);
        }
        finally {
            try {
                imageReader.dispose();
            }
            catch (Exception exception) {}
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RenderedImage getRenderedImage(File file) {
        RenderedImage renderedImage = null;
        ImageReader imageReader = ImgFile.getImageReader(file);
        if (imageReader == null) {
            return renderedImage;
        }
        try {
            renderedImage = imageReader.readAsRenderedImage(0, null);
        }
        catch (Exception e) {
            P2Log.errorLog(942136547, e);
        }
        finally {
            try {
                imageReader.dispose();
            }
            catch (Exception exception) {}
        }
        return renderedImage;
    }

    private static ImageReader getImageReader(File source2) {
        ImageReader imageReader = null;
        try {
            Iterator<ImageReader> imageReadersByFormatName = ImageIO.getImageReadersByFormatName(ImgTools.fileType(source2));
            imageReader = imageReadersByFormatName.next();
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(source2);
            imageReader.setInput(imageInputStream, true);
        }
        catch (Exception e) {
            P2Log.errorLog(674125980, "can't load image: " + source2.toString());
        }
        return imageReader;
    }

    public static void writeImage(BufferedImage img, String dest, String suffix, float jpgCompression) {
        ImgFile.writeImage(img, Paths.get(dest, new String[0]), suffix.equals(ImgFormat.JPG.suff) ? ImgFormat.JPG : ImgFormat.PNG, jpgCompression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeImage(BufferedImage bufferedImage, Path dest, ImgFormat suffix, float jpgCompression) {
        ImageWriter imageWriter = null;
        FileOutputStream fileOutputStream = null;
        ImageInputStream imageOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(dest.toFile());
            imageOutputStream = ImageIO.createImageOutputStream(fileOutputStream);
            if (suffix.equals((Object)ImgFormat.PNG)) {
                imageWriter = ImageIO.getImageWritersBySuffix(ImgFormat.PNG.suff).next();
                imageWriter.setOutput(imageOutputStream);
                imageWriter.write(new IIOImage(bufferedImage, null, null));
            } else {
                imageWriter = ImageIO.getImageWritersBySuffix(IMAGE_FORMAT_JPG).next();
                ImageWriteParam iwparam = imageWriter.getDefaultWriteParam();
                iwparam.setCompressionMode(2);
                iwparam.setCompressionQuality(jpgCompression);
                imageWriter.setOutput(imageOutputStream);
                imageWriter.write(null, new IIOImage(bufferedImage, null, null), iwparam);
            }
        }
        catch (Exception e) {
            P2Log.errorLog(784520369, e, ImgFile.class.toString());
            Platform.runLater(() -> P2Alert.showErrorAlert("Speichern", "Das Bild konnte nicht gespeichert werden." + P2LibConst.LINE_SEPARATORx2));
        }
        finally {
            try {
                imageOutputStream.flush();
                fileOutputStream.flush();
                imageWriter.dispose();
                imageOutputStream.close();
                fileOutputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static enum ImgFormat {
        JPG("jpg"),
        PNG("png");

        private final String suff;

        private ImgFormat(String suff) {
            this.suff = suff;
        }

        public String toString() {
            return this.suff;
        }
    }
}

