/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools.prange;

import de.p2tools.p2lib.guitools.P2GuiTools;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;
import org.controlsfx.control.RangeSlider;

public class P2RangeBox
extends VBox {
    private final String STR_ALLES = "Alles";
    private final int MIN_VALUE;
    private final int MAX_VALUE;
    private IntegerProperty minValueProp = new SimpleIntegerProperty();
    private IntegerProperty maxValueProp = new SimpleIntegerProperty();
    private final String pattern = "HH:mm";
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm");
    private String unitSuffix = "Minuten";
    private final RangeSlider slider;
    private final Label lblTime = new Label();
    private final String title;
    private boolean hourPerDay = false;

    public P2RangeBox(String title, boolean titleTop, int min, int max) {
        this.title = title;
        this.MIN_VALUE = min;
        this.MAX_VALUE = max;
        this.minValueProp.setValue(min);
        this.maxValueProp.setValue(max);
        this.slider = new RangeSlider(min, max, min, max);
        if (titleTop) {
            this.createSliderTop();
        } else {
            this.createSlider();
        }
    }

    public P2RangeBox(String title, boolean titleTop, int min, int max, IntegerProperty minValue, IntegerProperty maxValue) {
        this.title = title;
        this.MIN_VALUE = min;
        this.MAX_VALUE = max;
        this.minValueProp = minValue;
        this.maxValueProp = maxValue;
        this.slider = new RangeSlider(min, max, minValue.getValue().intValue(), maxValue.getValue().intValue());
        if (titleTop) {
            this.createSliderTop();
        } else {
            this.createSlider();
        }
    }

    public void setUnitSuffix(String unitSuffix) {
        this.unitSuffix = unitSuffix;
    }

    private void createSliderTop() {
        this.setSpacing(2.0);
        this.setMinHeight(Double.NEGATIVE_INFINITY);
        this.initSlider();
        this.setRangeTxt();
        HBox box = new HBox(5.0);
        box.setPadding(new Insets(0.0));
        box.getChildren().addAll((Node[])new Node[]{new Label(this.title), P2GuiTools.getHBoxGrower(), this.lblTime});
        this.getChildren().addAll((Node[])new Node[]{box, this.slider});
    }

    private void createSlider() {
        this.setSpacing(0.0);
        this.setMinHeight(Double.NEGATIVE_INFINITY);
        this.setPadding(new Insets(0.0));
        this.initSlider();
        this.slider.setPrefWidth(400.0);
        this.setRangeTxt();
        HBox hBox = new HBox(5.0);
        hBox.setPadding(new Insets(0.0));
        HBox.setHgrow(this.slider, Priority.ALWAYS);
        hBox.setAlignment(Pos.CENTER_RIGHT);
        if (this.title.isEmpty()) {
            hBox.getChildren().addAll((Node[])new Node[]{this.slider, P2GuiTools.getVDistance(20), this.getStack()});
        } else {
            hBox.getChildren().addAll((Node[])new Node[]{new Label(this.title), P2GuiTools.getVDistance(10), this.slider, P2GuiTools.getVDistance(20), this.getStack()});
        }
        this.getChildren().add(hBox);
    }

    private StackPane getStack() {
        Label l = new Label("Von " + this.MAX_VALUE + " bis " + this.MAX_VALUE + " " + this.unitSuffix);
        l.setVisible(false);
        StackPane stackPane = new StackPane();
        stackPane.getChildren().addAll((Node[])new Node[]{l, this.lblTime});
        stackPane.setAlignment(Pos.CENTER_RIGHT);
        return stackPane;
    }

    private void initSlider() {
        this.slider.lowValueProperty().bindBidirectional(this.minValueProp);
        this.slider.highValueProperty().bindBidirectional(this.maxValueProp);
        this.slider.highValueProperty().addListener((u, o, n) -> this.setRangeTxt());
        this.slider.lowValueProperty().addListener((u, o, n) -> this.setRangeTxt());
        this.slider.setShowTickMarks(false);
        this.slider.setShowTickLabels(true);
        this.slider.setBlockIncrement(10.0);
    }

    public RangeSlider getSlider() {
        return this.slider;
    }

    public void set24h() {
        this.unitSuffix = "Uhr";
        this.hourPerDay = true;
        this.slider.setSnapToTicks(true);
        this.slider.setMinorTickCount(15);
        this.slider.setMajorTickUnit(14400.0);
        this.slider.setLabelFormatter(new StringConverter<Number>(){

            @Override
            public String toString(Number x) {
                return "" + (int)(x.doubleValue() / 60.0 / 60.0);
            }

            @Override
            public Double fromString(String string) {
                return null;
            }
        });
    }

    public int getActMinValue() {
        return this.minValueProp.get();
    }

    public IntegerProperty minValueProperty() {
        return this.minValueProp;
    }

    public int getActMaxValue() {
        return this.maxValueProp.get();
    }

    public IntegerProperty maxValueProperty() {
        return this.maxValueProp;
    }

    private void setRangeTxt() {
        Object timeM;
        Object timeL;
        int minIntSlider = (int)this.slider.getLowValue();
        int maxIntSlider = (int)this.slider.getHighValue();
        if (this.hourPerDay) {
            LocalTime lt = LocalTime.ofSecondOfDay(minIntSlider == this.MAX_VALUE ? (long)(minIntSlider - 1) : (long)minIntSlider);
            timeL = lt.format(this.formatter);
            LocalTime mt = LocalTime.ofSecondOfDay(maxIntSlider == this.MAX_VALUE ? (long)(maxIntSlider - 1) : (long)maxIntSlider);
            timeM = mt.format(this.formatter);
        } else {
            timeL = "" + minIntSlider;
            timeM = "" + maxIntSlider;
        }
        Object text = minIntSlider == this.MIN_VALUE && maxIntSlider == this.MAX_VALUE ? "Alles" : (minIntSlider == this.MIN_VALUE ? "Max. " + (String)timeM + " " + this.unitSuffix : (maxIntSlider == this.MAX_VALUE ? "Min. " + (String)timeL + " " + this.unitSuffix : "Von " + (String)timeL + " bis " + (String)timeM + " " + this.unitSuffix));
        this.lblTime.setText((String)text);
    }
}

