/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools.pmask;

import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.effect.Lighting;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.util.Duration;

public class P2MaskerPaneIndeterminate
extends BorderPane {
    private boolean txtBtnHorizontal = true;
    private final VBox vBoxCont = new VBox();
    private final Label lblText = new Label("");
    private final Button btnStop = new Button("Stop");

    public P2MaskerPaneIndeterminate() {
        this.getStyleClass().add("p2MaskerPane");
        this.lblText.getStyleClass().add("p2MaskerTextLabel");
        this.btnStop.getStyleClass().add("p2MaskerButtonStop");
        this.setVBoxCont();
        this.setCenter(this.vBoxCont);
        this.setVisible(false);
    }

    public Button getButton() {
        return this.btnStop;
    }

    public void setButtonText(String text) {
        Platform.runLater(() -> this.btnStop.setText(text));
    }

    public void setButtonVisible(boolean buttonVisible) {
        Platform.runLater(() -> this.setBtnVisible(buttonVisible));
    }

    public void setTextVisible(boolean textVisible) {
        Platform.runLater(() -> this.setLblVisible(textVisible));
    }

    public void setMaskerText(String text) {
        Platform.runLater(() -> this.lblText.setText(text));
    }

    public void switchOffMasker() {
        this.setMaskerVisible(false, false, false);
    }

    public void setMaskerVisible() {
        Platform.runLater(() -> {
            this.setPaneVisible(true);
            this.setLblVisible(true);
            this.setBtnVisible(true);
        });
    }

    public void setMaskerVisible(boolean maskerVisible, boolean textVisible, boolean buttonVisible) {
        Platform.runLater(() -> {
            this.setPaneVisible(maskerVisible);
            this.setLblVisible(textVisible);
            this.setBtnVisible(buttonVisible);
        });
    }

    public boolean isTxtBtnHorizontal() {
        return this.txtBtnHorizontal;
    }

    public void setTxtBtnHorizontal(boolean txtBtnHorizontal) {
        this.txtBtnHorizontal = txtBtnHorizontal;
        this.setVBoxCont();
    }

    private void setBtnVisible(boolean visible) {
        this.btnStop.setVisible(visible);
        this.btnStop.setManaged(visible);
    }

    private void setLblVisible(boolean visible) {
        this.lblText.setVisible(visible);
        this.lblText.setManaged(visible);
    }

    private void setPaneVisible(boolean visible) {
        this.setVisible(visible);
    }

    private void setVBoxCont() {
        this.vBoxCont.getChildren().clear();
        this.vBoxCont.setMinWidth(500.0);
        this.vBoxCont.setMaxWidth(500.0);
        this.vBoxCont.setSpacing(20.0);
        this.vBoxCont.setPadding(new Insets(20.0));
        this.vBoxCont.setAlignment(Pos.CENTER);
        this.lblText.setMaxWidth(Double.MAX_VALUE);
        this.lblText.setAlignment(Pos.CENTER);
        this.lblText.setPadding(new Insets(5.0, 10.0, 5.0, 10.0));
        this.lblText.setMinHeight(this.btnStop.getHeight());
        this.setBtnVisible(false);
        if (this.txtBtnHorizontal) {
            HBox hBox = new HBox(10.0);
            hBox.setAlignment(Pos.CENTER);
            HBox.setHgrow(this.lblText, Priority.ALWAYS);
            hBox.getChildren().addAll((Node[])new Node[]{this.lblText, this.btnStop});
            this.vBoxCont.getChildren().addAll((Node[])new Node[]{this.animation(), hBox});
        } else {
            VBox vBox = new VBox(10.0);
            vBox.setAlignment(Pos.CENTER);
            vBox.getChildren().addAll((Node[])new Node[]{this.lblText, this.btnStop});
            this.vBoxCont.getChildren().addAll((Node[])new Node[]{this.animation(), vBox});
        }
    }

    private Node animation() {
        Circle circle = new Circle(20.0, Color.rgb(34, 67, 112));
        circle.setEffect(new Lighting());
        Timeline timeline = new Timeline(10.0);
        timeline.setCycleCount(-1);
        timeline.setAutoReverse(true);
        timeline.setRate(0.5);
        KeyValue keyValueX = new KeyValue(circle.scaleXProperty(), 2);
        KeyValue keyValueY = new KeyValue(circle.scaleYProperty(), 2);
        Duration duration = Duration.millis(2000.0);
        KeyFrame keyFrame = new KeyFrame(duration, keyValueX, keyValueY);
        timeline.getKeyFrames().add(keyFrame);
        timeline.play();
        HBox hBox = new HBox();
        hBox.setMinHeight(120.0);
        hBox.setPadding(new Insets(10.0));
        hBox.setAlignment(Pos.CENTER);
        hBox.getChildren().add(circle);
        return hBox;
    }
}

