/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools.pfiltercontrol;

import javafx.beans.property.StringProperty;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class P2FilterTextField
extends HBox {
    private final TextField textField = new TextField();
    private final Button btnClear = new Button("X");
    private StringProperty textProperty;

    public P2FilterTextField() {
        this.initHBox();
    }

    public P2FilterTextField(StringProperty textProperty) {
        this.textProperty = textProperty;
        this.initHBox();
        this.initTextField();
    }

    public void init(StringProperty selValueProperty) {
        this.textProperty = selValueProperty;
        this.initTextField();
    }

    public void bindTextProperty(StringProperty stringProperty) {
        this.unbind();
        this.textProperty = stringProperty;
        this.bind();
    }

    public void unbindTextProperty() {
        this.unbind();
        this.textProperty = null;
    }

    public String getText() {
        return this.textField.getText();
    }

    public void clearText() {
        this.textField.setText("");
    }

    private void initHBox() {
        this.getStyleClass().add("PFilterTextField");
        this.textField.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow(this.textField, Priority.ALWAYS);
        this.getChildren().addAll((Node[])new Node[]{this.textField, this.btnClear});
        this.btnClear.setOnAction(a -> this.clearText());
    }

    private void initTextField() {
        this.textField.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent != null && mouseEvent.getButton().equals((Object)MouseButton.PRIMARY) && mouseEvent.getClickCount() == 2) {
                this.clearText();
            }
        });
        this.bind();
    }

    private void bind() {
        if (this.textProperty == null) {
            this.clearText();
            return;
        }
        this.textField.textProperty().bindBidirectional(this.textProperty);
    }

    private void unbind() {
        if (this.textProperty == null) {
            this.clearText();
            return;
        }
        this.textField.textProperty().unbindBidirectional(this.textProperty);
    }
}

