/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools.pclosepane;

import de.p2tools.p2lib.P2ProgIcons;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class P2ClosePaneV
extends VBox {
    private final VBox vBoxAll = new VBox();
    private final boolean addScroll;
    private final boolean addRipButton;
    private final Button buttonClose = new Button();
    private final Button buttonRip = new Button();
    private final BooleanProperty showNoButton;

    public P2ClosePaneV() {
        this.addScroll = true;
        this.addRipButton = true;
        this.showNoButton = null;
        this.init();
    }

    public P2ClosePaneV(boolean addRipButton, boolean addScroll) {
        this.addScroll = addScroll;
        this.addRipButton = addRipButton;
        this.showNoButton = null;
        this.init();
    }

    public P2ClosePaneV(boolean addRipButton, boolean addScroll, BooleanProperty showNoButton) {
        this.addScroll = addScroll;
        this.addRipButton = addRipButton;
        this.showNoButton = showNoButton == null ? new SimpleBooleanProperty(true) : showNoButton;
        this.init();
    }

    public Button getButtonClose() {
        return this.buttonClose;
    }

    public Button getButtonRip() {
        return this.buttonRip;
    }

    public void addPane(Pane pane) {
        this.getVBoxAll().getChildren().add(pane);
    }

    public VBox getVBoxAll() {
        return this.vBoxAll;
    }

    private void init() {
        this.buttonClose.getStyleClass().add("close-button");
        this.buttonClose.setGraphic(P2ProgIcons.ICON_BUTTON_CLOSE.getImageView());
        this.buttonRip.getStyleClass().add("rip-button");
        this.buttonRip.setGraphic(P2ProgIcons.ICON_BUTTON_RIP.getImageView());
        HBox hBox = new HBox(10.0);
        hBox.getStyleClass().add("close-pane");
        hBox.setAlignment(Pos.TOP_RIGHT);
        if (this.showNoButton != null) {
            hBox.visibleProperty().bind(this.showNoButton.not());
            hBox.managedProperty().bind(this.showNoButton.not());
        }
        if (this.addRipButton) {
            hBox.getChildren().addAll((Node[])new Node[]{this.buttonRip, this.buttonClose});
        } else {
            hBox.getChildren().addAll((Node[])new Node[]{this.buttonClose});
        }
        if (this.addScroll) {
            ScrollPane scrollPane = new ScrollPane();
            scrollPane.setFitToHeight(true);
            scrollPane.setFitToWidth(true);
            scrollPane.setContent(this.vBoxAll);
            this.getChildren().addAll((Node[])new Node[]{hBox, scrollPane});
            VBox.setVgrow(scrollPane, Priority.ALWAYS);
        } else {
            this.getChildren().addAll((Node[])new Node[]{hBox, this.vBoxAll});
            VBox.setVgrow(this.vBoxAll, Priority.ALWAYS);
        }
    }
}

