/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools;

import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.P2ProgIcons;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.File;
import javafx.scene.image.Image;
import javafx.stage.Stage;

public class P2WindowIcon {
    private P2WindowIcon() {
    }

    public static void setStageIcon(String imagePath) {
        if (imagePath.isEmpty()) {
            P2LibConst.STAGE_ICON = P2LibConst.STAGE_ICON_ORG;
        } else {
            try {
                File file = new File(imagePath);
                if (file.exists()) {
                    P2LibConst.STAGE_ICON = new Image(file.toURI().toString(), 58.0, 58.0, true, true);
                } else {
                    P2Log.sysLog("Das vorgegebene Programm-Icon gibt es nicht");
                    P2LibConst.STAGE_ICON = P2LibConst.STAGE_ICON_ORG;
                }
            }
            catch (Exception ex) {
                P2Log.errorLog(987545412, ex, "Kann das vorgegebene Programm-Icon nicht setzen");
                P2LibConst.STAGE_ICON = P2LibConst.STAGE_ICON_ORG;
            }
        }
        P2WindowIcon.addWindowIcon();
    }

    public static void setOrgIcon(String imagePath) {
        if (imagePath.isEmpty()) {
            P2LibConst.STAGE_ICON_ORG = P2ProgIcons.P2_STAGE_ICON.getImage();
            return;
        }
        try {
            Image image;
            P2LibConst.STAGE_ICON_ORG = image = new Image(ClassLoader.getSystemResource(imagePath).toURI().toString(), 58.0, 58.0, true, true);
        }
        catch (Exception ex) {
            P2Log.errorLog(987545412, ex, "Kann das vorgegebene Programm-Icon nicht setzen");
            P2LibConst.STAGE_ICON_ORG = P2ProgIcons.P2_STAGE_ICON.getImage();
        }
    }

    public static void addWindowIcon() {
        P2WindowIcon.addWindowIcon(P2LibConst.actStage);
        P2DialogExtra.setIconForAllDialog();
    }

    public static void addWindowIcon(Stage stage) {
        if (stage == null) {
            return;
        }
        try {
            stage.getIcons().clear();
            stage.getIcons().add(0, P2LibConst.STAGE_ICON);
        }
        catch (Exception ex) {
            P2Log.errorLog(945720146, "Kann Window-Icon nicht setzen");
            stage.getIcons().add(0, P2ProgIcons.P2_STAGE_ICON.getImage());
        }
    }
}

