/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools;

import de.p2tools.p2lib.alert.P2Alert;
import java.util.List;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.util.Callback;

public class P2RowMoveFactory<T>
implements Callback<TableView<T>, TableRow<T>> {
    private final Callback<TableView<T>, TableRow<T>> baseFactory;
    private final IntegerProperty startPos = new SimpleIntegerProperty();
    private final List<T> fromList;

    public P2RowMoveFactory() {
        this(null, null);
    }

    public P2RowMoveFactory(List<T> fromList) {
        this.baseFactory = null;
        this.fromList = fromList;
    }

    public P2RowMoveFactory(Callback<TableView<T>, TableRow<T>> baseFactory) {
        this.baseFactory = baseFactory;
        this.fromList = null;
    }

    public P2RowMoveFactory(Callback<TableView<T>, TableRow<T>> baseFactory, List<T> fromList) {
        this.baseFactory = baseFactory;
        this.fromList = fromList;
    }

    @Override
    public TableRow<T> call(TableView<T> tableView) {
        TableRow row = this.baseFactory == null ? new TableRow() : this.baseFactory.call(tableView);
        row.setOnDragDetected(event -> {
            if (!event.isPrimaryButtonDown()) {
                return;
            }
            if (event.isControlDown() && this.fromList != null && !tableView.getSortOrder().isEmpty()) {
                System.out.println("getSortOrder");
                String s = ((TableColumn)tableView.getSortOrder().get(0)).getText();
                P2Alert.showInfoAlert("Sortieren", "Zeilen verschieben", "Die Tabelle wird nach:\n >> " + s + " <<\nsortiert. So k\u00f6nnen keine Zeilen verschoben werden. Die Sortierung wird zuerst gel\u00f6scht.");
                this.startPos.set(-1);
                tableView.getSortOrder().clear();
                row.startFullDrag();
                tableView.getSelectionModel().clearSelection();
                tableView.getSelectionModel().select(row.getItem());
                return;
            }
            System.out.println("startFullDrag");
            this.startPos.set(-1);
            row.startFullDrag();
            tableView.getSelectionModel().clearSelection();
            tableView.getSelectionModel().select(row.getItem());
        });
        row.setOnMouseDragEntered(event -> {
            if (!event.isPrimaryButtonDown()) {
                return;
            }
            System.out.println("<- setOnMouseDragEntered");
            System.out.println("Row: " + row.getIndex());
            if (!event.isControlDown() || this.fromList == null) {
                tableView.getSelectionModel().select(row.getItem());
            } else {
                if (this.startPos.get() == -1) {
                    return;
                }
                if (tableView.getItems().size() <= this.startPos.get()) {
                    return;
                }
                int destPos = row.getIndex();
                if (tableView.getItems().size() <= destPos) {
                    return;
                }
                Object stationSrc = tableView.getItems().get(this.startPos.get());
                Object stationDest = tableView.getItems().get(destPos);
                int src = this.fromList.indexOf(stationSrc);
                int dest = this.fromList.indexOf(stationDest);
                if (dest == src) {
                    return;
                }
                this.fromList.remove(stationSrc);
                this.fromList.remove(stationDest);
                if (dest > src) {
                    this.fromList.add(src, stationDest);
                    this.fromList.add(dest, stationSrc);
                } else if (dest < src) {
                    this.fromList.add(dest, stationSrc);
                    this.fromList.add(src, stationDest);
                }
                tableView.getSelectionModel().clearSelection();
                tableView.getSelectionModel().select(stationSrc);
            }
        });
        row.setOnMouseDragExited(event -> {
            System.out.println("-> setOnMouseDragExited");
            System.out.println("Row: " + row.getIndex());
            if (event.isControlDown()) {
                this.startPos.set(row.getIndex());
            }
        });
        return row;
    }
}

