/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools;

import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;

public class P2ProgressBar
extends StackPane {
    private double progress = 0.0;
    private String progressText = "";
    private final ProgressBar progressBar = new ProgressBar();
    private final Text text = new Text();

    public P2ProgressBar() {
        this.getChildren().setAll((Node[])new Node[]{this.progressBar, this.text});
        this.setPadding(new Insets(10.0));
        P2ProgressBar.setAlignment(this.progressBar, Pos.CENTER);
        P2ProgressBar.setAlignment(this.text, Pos.CENTER);
        this.setProgress();
        this.progressBar.getStyleClass().add("pProgressBar");
        this.progressBar.setMinWidth(100.0);
        this.progressBar.setMaxWidth(Double.MAX_VALUE);
    }

    public void setProgress(double progress, String progressText) {
        this.progress = progress;
        this.progressText = progressText;
        this.setProgress();
    }

    private void setProgress() {
        this.text.setText(this.progressText);
        this.progressBar.setProgress(this.progress);
        this.progressBar.setMinHeight(this.text.getBoundsInLocal().getHeight() + 5.0);
        this.progressBar.setMinWidth(this.text.getBoundsInLocal().getWidth() + 25.0);
    }

    public ProgressBar getProgressBar() {
        return this.progressBar;
    }
}

