/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools;

import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.tools.log.P2Log;
import java.awt.Toolkit;
import java.lang.reflect.Field;

public class P2LinuxJavaFx {
    private static final String X11_AWT_APP_CLASS_NAME = "awtAppClassName";
    private static final String JAVAFX_CLASSNAME_APPLICATION_PLATFORM = "javafx.application.Platform";
    private static final String ERROR_NO_JAVAFX_INSTALLED = "JavaFX wurde nicht im Klassenpfad gefunden. " + P2LibConst.LINE_SEPARATOR + "Stellen Sie sicher, dass Sie ein Java JRE ab Version 8 benutzen. " + P2LibConst.LINE_SEPARATOR + "Falls Sie Linux nutzen, installieren Sie das openjfx-Paket ihres " + P2LibConst.LINE_SEPARATOR + "Package-Managers, oder nutzen Sie eine eigene JRE-Installation.";
    private static final String TEXT_LINE = "===========================================";

    public static boolean hasJavaFx() {
        try {
            Class.forName(JAVAFX_CLASSNAME_APPLICATION_PLATFORM);
            return true;
        }
        catch (ClassNotFoundException e) {
            P2Log.errorLog(487651240, new String[]{TEXT_LINE, ERROR_NO_JAVAFX_INSTALLED, TEXT_LINE});
            return false;
        }
    }

    public static void setupX11WindowManagerClassName(String progName) {
        try {
            Toolkit xToolkit = Toolkit.getDefaultToolkit();
            Field awtAppClassNameField = xToolkit.getClass().getDeclaredField(X11_AWT_APP_CLASS_NAME);
            awtAppClassNameField.setAccessible(true);
            awtAppClassNameField.set(xToolkit, progName);
        }
        catch (Exception ignored) {
            System.err.println("Couldn't set awtAppClassName");
        }
    }
}

