/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.collections.ObservableList;
import javafx.scene.control.ComboBox;
import javafx.scene.input.MouseButton;

public class P2ComboBoxObject<E>
extends ComboBox<E> {
    private ObservableList<E> itemsList;
    private ObjectProperty<E> selVaueProperty;

    public P2ComboBoxObject() {
    }

    public P2ComboBoxObject(ObservableList<E> itemsList, ObjectProperty<E> selVaueProperty) {
        this.itemsList = itemsList;
        this.selVaueProperty = selVaueProperty;
        this.setCombo();
    }

    public void init(ObservableList<E> itemsList) {
        this.itemsList = itemsList;
        this.selectElement();
        this.setCombo();
    }

    public void init(ObservableList<E> itemsList, ObjectProperty<E> selVaueProperty) {
        this.itemsList = itemsList;
        this.selVaueProperty = selVaueProperty;
        this.selectElement();
        this.setCombo();
    }

    public void bindSelValueProperty(ObjectProperty<E> property) {
        this.unbind();
        this.selVaueProperty = property;
        this.bind();
    }

    public void unbindSelValueProperty() {
        this.unbind();
        this.selVaueProperty = null;
        this.getSelectionModel().clearSelection();
    }

    public E getSelValue() {
        Object s = this.getSelectionModel().getSelectedItem();
        return (E)s;
    }

    public ReadOnlyObjectProperty<E> getSelValueProperty() {
        ReadOnlyObjectProperty s = this.getSelectionModel().selectedItemProperty();
        return s;
    }

    public void selectElement() {
        if (this.selVaueProperty == null) {
            this.getSelectionModel().clearSelection();
        } else {
            this.setValue(this.selVaueProperty.getValue());
        }
    }

    public void clearSelection() {
        this.getSelectionModel().clearSelection();
    }

    private void setCombo() {
        this.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent != null && mouseEvent.getButton().equals((Object)MouseButton.PRIMARY) && mouseEvent.getClickCount() == 2) {
                this.getSelectionModel().clearSelection();
            }
        });
        if (this.itemsList == null) {
            return;
        }
        this.setItems(this.itemsList);
        this.bind();
    }

    private void bind() {
        if (this.selVaueProperty == null) {
            return;
        }
        this.valueProperty().bindBidirectional(this.selVaueProperty);
    }

    private void unbind() {
        if (this.selVaueProperty == null) {
            this.getSelectionModel().clearSelection();
            return;
        }
        this.valueProperty().unbindBidirectional(this.selVaueProperty);
    }
}

