/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.dialogs;

import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.P2ProgIcons;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2ClipBoardContext;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2Hyperlink;
import de.p2tools.p2lib.tools.P2InfoFactory;
import javafx.beans.property.StringProperty;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.Stage;

public abstract class AboutDialog
extends P2DialogExtra {
    private final Button btnOk = new Button("_Ok");
    private final Button btnCheck = new Button("_Programmupdate pr\u00fcfen");
    private final Color PROG_COLOR_MARK;
    private final Color PROG_COLOR;
    private final String progName;
    private final String URL_WEBSITE;
    private final String URL_WEBSITE_HELP;
    private final StringProperty urlOpenProg;
    private final String[] listName;
    private final String[] listValue;

    public AboutDialog(Stage stage, String progName, String URL_WEBSITE, String URL_WEBSITE_HELP, StringProperty urlOpenProg, boolean dark, String[] listName, String[] listValue, boolean masker) {
        super(stage, null, "\u00dcber das Programm", true, false, P2DialogExtra.DECO.BORDER_SMALL, masker);
        this.progName = progName;
        this.URL_WEBSITE = URL_WEBSITE;
        this.URL_WEBSITE_HELP = URL_WEBSITE_HELP;
        this.urlOpenProg = urlOpenProg;
        ImageView imageView = new ImageView();
        imageView.setSmooth(true);
        imageView.setCache(true);
        if (dark) {
            this.PROG_COLOR_MARK = Color.rgb(244, 244, 255);
            this.PROG_COLOR = Color.rgb(200, 200, 209);
        } else {
            this.PROG_COLOR_MARK = Color.rgb(0, 0, 75);
            this.PROG_COLOR = Color.rgb(0, 0, 75);
        }
        this.listName = listName;
        this.listValue = listValue;
        this.addOkButton(this.btnOk);
        this.getHboxLeft().getChildren().add(this.btnCheck);
        this.init(false);
    }

    @Override
    public void make() {
        this.makeGrid();
    }

    public void runCheckButton() {
    }

    private void makeGrid() {
        this.getVBoxCont().setSpacing(5.0);
        this.btnOk.setOnAction(a -> this.close());
        this.btnCheck.setOnAction(a -> this.runCheckButton());
        GridPane gridPane = this.getGridPane();
        int row = 0;
        HBox hBox = new HBox();
        hBox.getChildren().add(gridPane);
        hBox.setAlignment(Pos.CENTER);
        hBox.getStyleClass().add("dialog-about");
        this.getVBoxCont().getChildren().add(hBox);
        ImageView iv = new ImageView();
        Image im = P2ProgIcons.P2_ABOUT_ICON.getImage(128, 128);
        iv.setSmooth(true);
        iv.setCache(true);
        iv.setImage(im);
        gridPane.add(iv, 0, row, 1, 3);
        Text text1 = new Text(this.progName);
        text1.setFont(Font.font(null, FontWeight.BOLD, 40.0));
        text1.setFill(this.PROG_COLOR_MARK);
        gridPane.add(text1, 1, row);
        GridPane.setValignment(text1, VPos.TOP);
        GridPane.setHalignment(text1, HPos.CENTER);
        Text text2 = new Text(P2LibConst.LINE_SEPARATOR + "Version: " + P2InfoFactory.getProgVersion());
        text2.setFont(new Font(18.0));
        text2.setFill(this.PROG_COLOR);
        gridPane.add(text2, 1, ++row);
        GridPane.setHalignment(text2, HPos.CENTER);
        Text text3 = new Text("[ Build: " + P2InfoFactory.getBuildNo() + " vom " + P2InfoFactory.getBuildDate() + " ]");
        text3.setFont(new Font(15.0));
        text3.setFill(this.PROG_COLOR);
        gridPane.add(text3, 1, ++row);
        GridPane.setValignment(text3, VPos.BOTTOM);
        GridPane.setHalignment(text3, HPos.CENTER);
        HBox.setHgrow(gridPane, Priority.ALWAYS);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        P2ClipBoardContext.addMenu("Infos kopieren", text1.getText() + "\n" + text2.getText() + "\n" + text3.getText(), (Node)gridPane);
        gridPane = this.getGridPane();
        row = 0;
        int c = 0;
        Text text = new Text("Autor");
        text.setFont(Font.font(null, FontWeight.BOLD, 15.0));
        text.setFill(this.PROG_COLOR_MARK);
        gridPane.add(text, c, row, 2, 1);
        text = new Text("Xaver W. (xaverW)");
        text.setFont(new Font(15.0));
        text.setFill(this.PROG_COLOR);
        gridPane.add(text, c, ++row, 2, 1);
        Text textM = new Text("w.xaver@googlemail.com");
        textM.setFont(new Font(14.0));
        textM.setFill(this.PROG_COLOR);
        gridPane.add(textM, c, ++row, 2, 1);
        P2ClipBoardContext.addMenu("Mail kopieren", "w.xaver@googlemail.com", (Node)gridPane);
        StringBuilder txtContext = new StringBuilder();
        gridPane = this.getGridPane();
        row = 0;
        text = new Text("Programm Informationen");
        text.setFont(Font.font(null, FontWeight.BOLD, 15.0));
        text.setFill(this.PROG_COLOR_MARK);
        txtContext.append(text.getText());
        gridPane.add(text, c, row, 2, 1);
        P2Hyperlink hyperlinkWeb = new P2Hyperlink(this.URL_WEBSITE, this.urlOpenProg);
        P2Hyperlink hyperlinkHelp = new P2Hyperlink(this.URL_WEBSITE_HELP, this.urlOpenProg);
        P2Hyperlink hyperlinkForum = new P2Hyperlink("https://p2forum.de", this.urlOpenProg);
        P2Hyperlink hyperlinkDonate = new P2Hyperlink("https://www.p2tools.de/donate/", this.urlOpenProg);
        txtContext.append("\n").append("Website: ").append(hyperlinkWeb.getText()).append("\n").append("Anleitung: ").append(hyperlinkHelp.getText()).append("\n").append("Spende: ").append(hyperlinkDonate.getText()).append("\n").append("Forum: ").append(hyperlinkForum.getText());
        text = new Text("Website:");
        text.setFont(new Font(15.0));
        text.setFill(this.PROG_COLOR);
        gridPane.add(text, c, ++row);
        gridPane.add(hyperlinkWeb, c + 1, row);
        text = new Text("Anleitung:");
        text.setFont(new Font(15.0));
        text.setFill(this.PROG_COLOR);
        gridPane.add(text, c, ++row);
        gridPane.add(hyperlinkHelp, c + 1, row);
        text = new Text("Spende:");
        text.setFont(new Font(15.0));
        text.setFill(this.PROG_COLOR);
        gridPane.add(text, c, ++row);
        gridPane.add(hyperlinkDonate, c + 1, row);
        text = new Text("Forum:");
        text.setFont(new Font(15.0));
        text.setFill(this.PROG_COLOR);
        gridPane.add(text, c, ++row);
        gridPane.add(hyperlinkForum, c + 1, row);
        gridPane.add(new Label(""), c, ++row);
        for (int i = 0; i < this.listName.length && i < this.listValue.length; ++i) {
            text = new Text(this.listName[i]);
            text.setFont(new Font(15.0));
            text.setFill(this.PROG_COLOR);
            gridPane.add(text, c, ++row);
            text = new Text(this.listValue[i]);
            text.setFont(new Font(15.0));
            text.setFill(this.PROG_COLOR);
            gridPane.add(text, c + 1, row);
            txtContext.append("\n").append(this.listName[i]).append(": ").append(this.listValue[i]);
        }
        P2ClipBoardContext.addMenu("Programm-Infos kopieren", txtContext.toString(), (Node)gridPane);
        txtContext = new StringBuilder();
        gridPane = this.getGridPane();
        row = 0;
        text = new Text("Java Informationen");
        text.setFont(Font.font(null, FontWeight.BOLD, 15.0));
        text.setFill(this.PROG_COLOR_MARK);
        gridPane.add(text, c, row, 2, 1);
        txtContext.append("Java Informationen");
        text = new Text("Version:");
        text.setFont(new Font(15.0));
        text.setFill(this.PROG_COLOR);
        gridPane.add(text, c, ++row);
        text = new Text(System.getProperty("java.version"));
        text.setFont(new Font(15.0));
        text.setFill(this.PROG_COLOR);
        gridPane.add(text, c + 1, row);
        txtContext.append("\n").append("Version: ").append(text.getText());
        text = new Text("Type:");
        text.setFont(new Font(15.0));
        text.setFill(this.PROG_COLOR);
        gridPane.add(text, c, ++row);
        Object strVmType = System.getProperty("java.vm.name");
        strVmType = (String)strVmType + " (" + System.getProperty("java.vendor") + ")";
        text = new Text((String)strVmType);
        text.setFont(new Font(15.0));
        text.setFill(this.PROG_COLOR);
        gridPane.add(text, c + 1, row);
        txtContext.append("\n").append("Type: ").append(text.getText());
        text = new Text("JavaFX:");
        text.setFont(new Font(15.0));
        text.setFill(this.PROG_COLOR);
        gridPane.add(text, c, ++row);
        String fxVmType = System.getProperty("javafx.runtime.version");
        text = new Text(fxVmType);
        text.setFont(new Font(15.0));
        text.setFill(this.PROG_COLOR);
        gridPane.add(text, c + 1, row);
        txtContext.append("\n").append("JavaFX: ").append(text.getText());
        long totalMem = Runtime.getRuntime().totalMemory();
        String totalMemStr = "" + totalMem / 1000000L;
        long maxMem = Runtime.getRuntime().maxMemory();
        String maxMemStr = "" + maxMem / 1000000L;
        long freeMem = Runtime.getRuntime().freeMemory();
        String freeMemStr = "" + freeMem / 1000000L;
        text = new Text("Speicher [MB]:");
        text.setFont(new Font(15.0));
        text.setFill(this.PROG_COLOR);
        gridPane.add(text, c, ++row);
        text = new Text(totalMemStr + ",  max: " + maxMemStr + ",  frei: " + freeMemStr);
        text.setFont(new Font(15.0));
        text.setFill(this.PROG_COLOR);
        gridPane.add(text, c + 1, row);
        txtContext.append("\n").append("Speicher (max / frei): ").append(text.getText());
        P2ClipBoardContext.addMenu("Java-Infos kopieren", txtContext.toString(), (Node)gridPane);
        gridPane = this.getGridPane();
        row = 0;
        text = new Text("Ein Dankesch\u00f6n an alle," + P2LibConst.LINE_SEPARATOR + "die mit Vorschl\u00e4gen oder Quelltext" + P2LibConst.LINE_SEPARATOR + "zu diesem Programm beigetragen haben.");
        text.setFont(Font.font(null, FontWeight.BOLD, 15.0));
        text.setFill(this.PROG_COLOR_MARK);
        gridPane.add(text, c, row, 2, 1);
    }

    private GridPane getGridPane() {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(10.0);
        gridPane.setVgap(3.0);
        gridPane.setPadding(new Insets(0.0, 10.0, 10.0, 10.0));
        this.getVBoxCont().getChildren().add(gridPane);
        return gridPane;
    }
}

