/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.configfile.config;

import de.p2tools.p2lib.configfile.config.Config;
import java.text.DecimalFormat;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.util.converter.BooleanStringConverter;
import javafx.util.converter.NumberStringConverter;

public class Config_all
extends Config {
    private final String key;
    private final String init;
    private final StringProperty aktValue;

    public Config_all(String key) {
        this.key = key;
        this.init = "";
        this.aktValue = new SimpleStringProperty(this.init);
    }

    public Config_all(String key, String init) {
        this.key = key;
        this.init = init;
        this.aktValue = new SimpleStringProperty(this.init);
    }

    public Config_all(String key, int init) {
        this.key = key;
        this.init = String.valueOf(init);
        this.aktValue = new SimpleStringProperty(this.init);
    }

    public Config_all(String key, boolean init) {
        this.key = key;
        this.init = String.valueOf(init);
        this.aktValue = new SimpleStringProperty(this.init);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public StringProperty getAktValue() {
        return this.aktValue;
    }

    public synchronized void setValue(String value) {
        this.getAktValue().setValue(value == null ? "" : value);
    }

    public synchronized void setValue(boolean value) {
        this.getAktValue().setValue(String.valueOf(value));
    }

    public synchronized void setValue(int value) {
        this.getAktValue().setValue(String.valueOf(value));
    }

    public synchronized void setValue(long value) {
        this.getAktValue().setValue(String.valueOf(value));
    }

    public synchronized void setValue(double value) {
        this.getAktValue().setValue(String.valueOf(value));
    }

    public synchronized String get() {
        return this.aktValue.getValue();
    }

    public synchronized boolean getBool() {
        return Boolean.parseBoolean(this.aktValue.getValue());
    }

    public synchronized int getInt() {
        int ret;
        try {
            ret = Integer.parseInt(this.aktValue.getValue());
        }
        catch (Exception ignore) {
            this.aktValue.setValue("0");
            ret = 0;
        }
        return ret;
    }

    public synchronized long getLong() {
        long ret;
        try {
            ret = Long.parseLong(this.aktValue.getValue());
        }
        catch (Exception ignore) {
            this.aktValue.setValue("0");
            ret = 0L;
        }
        return ret;
    }

    public synchronized double getDouble() {
        double ret;
        try {
            String s = this.aktValue.getValue();
            ret = Double.parseDouble(s);
        }
        catch (Exception ignore) {
            this.aktValue.setValue("0");
            ret = 0.0;
        }
        return ret;
    }

    public synchronized StringProperty getStringProperty() {
        return this.aktValue;
    }

    public synchronized BooleanProperty getBooleanProperty() {
        StringProperty sp = this.getStringProperty();
        SimpleBooleanProperty ip = new SimpleBooleanProperty();
        try {
            ip.setValue(Boolean.parseBoolean(sp.getValue()));
        }
        catch (Exception ex) {
            sp.setValue(Boolean.TRUE.toString());
            ip.setValue(true);
        }
        BooleanStringConverter converter = new BooleanStringConverter();
        Bindings.bindBidirectional((Property<String>)sp, ip, converter);
        return ip;
    }

    public IntegerProperty getIntegerProperty() {
        StringProperty sp = this.getStringProperty();
        SimpleIntegerProperty ip = new SimpleIntegerProperty();
        try {
            ip.setValue(Integer.parseInt(sp.getValue()));
        }
        catch (Exception ex) {
            sp.setValue("0");
            ip.setValue(0);
        }
        NumberStringConverter converter = new NumberStringConverter(new DecimalFormat("##"));
        Bindings.bindBidirectional((Property<String>)sp, ip, converter);
        return ip;
    }

    public LongProperty getLongProperty() {
        StringProperty sp = this.getStringProperty();
        SimpleLongProperty lp = new SimpleLongProperty();
        try {
            lp.setValue(Long.parseLong(sp.getValue()));
        }
        catch (Exception ex) {
            sp.setValue("0");
            lp.setValue(0);
        }
        NumberStringConverter converter = new NumberStringConverter(new DecimalFormat("##"));
        Bindings.bindBidirectional((Property<String>)sp, lp, converter);
        return lp;
    }

    public synchronized DoubleProperty getDoubleProperty() {
        StringProperty sp = this.getStringProperty();
        SimpleDoubleProperty dp = new SimpleDoubleProperty();
        try {
            dp.setValue(Double.parseDouble(sp.getValue()));
        }
        catch (Exception ex) {
            sp.setValue("0");
            dp.setValue(0);
        }
        NumberStringConverter converter = new NumberStringConverter(new DecimalFormat("##"));
        Bindings.bindBidirectional((Property<String>)sp, dp, converter);
        return dp;
    }
}

