/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.configfile;

import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.tools.P2Exception;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.lang3.SystemUtils;

public class SettingsDirectory {
    public static Path getSettingsFile(String configPath, String stdConfigPath, String configFile) {
        return SettingsDirectory.getSettingsDirectory(configPath, stdConfigPath).resolve(configFile);
    }

    public static Path getSettingsDirectory(String configDir, String stdDir) throws IllegalStateException {
        Path baseDirectoryPath = configDir == null || configDir.isEmpty() ? (SystemUtils.IS_OS_WINDOWS ? Paths.get(System.getProperty("user.home"), stdDir) : Paths.get(System.getProperty("user.home"), "." + stdDir)) : Paths.get(configDir, new String[0]);
        SettingsDirectory.makeDirs(baseDirectoryPath);
        return baseDirectoryPath;
    }

    private static void makeDirs(Path path) {
        if (Files.notExists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
                if (SystemUtils.IS_OS_WINDOWS) {
                    try {
                        Files.setAttribute(path, "dos:hidden", Boolean.TRUE, LinkOption.NOFOLLOW_LINKS);
                    }
                    catch (IOException ex) {
                        P2Log.errorLog(795412365, ex);
                    }
                }
            }
            catch (IOException ioException) {
                P2Log.errorLog(912030306, (Exception)ioException, "Ordner anlegen: " + String.valueOf(path));
                P2Alert.showErrorAlert("Ordner anlegen", " Der Ordner " + String.valueOf(path) + " konnte nicht angelegt werden." + P2LibConst.LINE_SEPARATOR + "Bitte pr\u00fcfen Sie die Dateirechte.");
                throw new P2Exception(" Der Ordner " + String.valueOf(path) + " konnte nicht angelegt werden." + P2LibConst.LINE_SEPARATOR + "Bitte pr\u00fcfen Sie die Dateirechte.", ioException);
            }
        }
    }
}

