/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.configfile;

import de.p2tools.p2lib.configfile.ConfigFile;
import de.p2tools.p2lib.configfile.config.Config;
import de.p2tools.p2lib.configfile.config.Config_pData;
import de.p2tools.p2lib.configfile.config.Config_pDataList;
import de.p2tools.p2lib.configfile.configlist.ConfigList;
import de.p2tools.p2lib.configfile.pdata.P2Data;
import de.p2tools.p2lib.configfile.pdata.P2DataList;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.InputStreamReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

class ConfigRead
implements AutoCloseable {
    private final ConfigFile configFile;
    private final XMLInputFactory inFactory;

    ConfigRead(ConfigFile configFile) {
        this.configFile = configFile;
        this.inFactory = XMLInputFactory.newInstance();
        this.inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
        this.inFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        this.inFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean read(InputStreamReader in) {
        boolean ret;
        XMLStreamReader parser = null;
        try {
            parser = this.inFactory.createXMLStreamReader(in);
            while (parser.hasNext()) {
                String xmlElem;
                int event = parser.next();
                if (event == 1 && !this.get(parser, xmlElem = parser.getLocalName())) continue;
            }
            ret = true;
        }
        catch (Exception ex) {
            ret = false;
            P2Log.errorLog(915263478, ex);
        }
        finally {
            try {
                if (parser != null) {
                    parser.close();
                }
            }
            catch (Exception exception) {}
        }
        return ret;
    }

    private boolean get(XMLStreamReader parser, String xmlElem) {
        if (this.configFile.getpDataList() != null) {
            for (P2DataList p2DataList : this.configFile.getpDataList()) {
                if (!this.checkTag(p2DataList.getTag(), xmlElem)) continue;
                this.getConf(parser, p2DataList);
                return true;
            }
        }
        if (this.configFile.getpData() != null) {
            for (P2Data p2Data : this.configFile.getpData()) {
                if (!this.checkTag(p2Data.getTag(), xmlElem)) continue;
                this.getConf(parser, p2Data);
                return true;
            }
        }
        return false;
    }

    private boolean getConf(XMLStreamReader parser, Object o) {
        if (o instanceof P2Data) {
            return this.getPData(parser, (P2Data)o);
        }
        if (o instanceof P2DataList) {
            return this.getPDataList(parser, (P2DataList)o);
        }
        if (o instanceof Config_pDataList) {
            P2DataList actValue = ((Config_pDataList)o).getActValue();
            return this.getPDataList(parser, actValue);
        }
        if (o instanceof Config_pData) {
            P2Data cd = ((Config_pData)o).getActValue();
            return this.getPData(parser, cd);
        }
        if (o instanceof ConfigList) {
            return this.getConfigList(parser, (ConfigList)o);
        }
        if (o instanceof Config) {
            return this.getConfig(parser, (Config)o);
        }
        P2Log.sysLog("Fehler beim Lesen: " + o.getClass().toString());
        return false;
    }

    private boolean getPDataList(XMLStreamReader parser, P2DataList p2DataList) {
        boolean ret = false;
        try {
            int event;
            P2Data p2Data = p2DataList.getNewItem();
            while (parser.hasNext() && ((event = parser.next()) != 2 || !this.checkTag(p2DataList.getTag(), parser.getLocalName()))) {
                if (event != 1 || !this.checkTag(p2Data.getTag(), parser.getLocalName()) || !this.getConf(parser, p2Data)) continue;
                ret = true;
                p2DataList.addNewItem(p2Data);
                p2Data = p2DataList.getNewItem();
            }
        }
        catch (Exception ex) {
            ret = false;
            P2Log.errorLog(975102305, ex);
        }
        return ret;
    }

    private boolean getPData(XMLStreamReader parser, P2Data p2Data) {
        boolean ret = false;
        String xmlElem = parser.getLocalName();
        try {
            int event;
            Config[] configs = p2Data.getConfigsArr();
            block2: while (parser.hasNext() && ((event = parser.next()) != 2 || !parser.getLocalName().equals(xmlElem))) {
                if (event != 1) continue;
                for (Config config : configs) {
                    if (!this.checkTag(config.getKey(), parser.getLocalName())) continue;
                    this.getConf(parser, config);
                    continue block2;
                }
            }
            ret = true;
        }
        catch (Exception ex) {
            P2Log.errorLog(102365494, ex);
        }
        return ret;
    }

    private boolean getConfigList(XMLStreamReader parser, ConfigList config) {
        try {
            int event;
            while (parser.hasNext() && ((event = parser.next()) != 2 || !this.checkTag(config.getKey(), parser.getLocalName()))) {
                if (event != 1) continue;
                String n = parser.getElementText();
                config.setActValue(n);
            }
        }
        catch (Exception ex) {
            P2Log.errorLog(302104587, ex);
            return false;
        }
        return true;
    }

    private boolean getConfig(XMLStreamReader parser, Config config) {
        try {
            String n = parser.getElementText();
            config.setActValue(n);
        }
        catch (XMLStreamException ex) {
            return false;
        }
        return true;
    }

    private boolean checkTag(String checkTag, String xmlElem) {
        for (String s : checkTag.split(":")) {
            if (!s.equals(xmlElem)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void close() throws Exception {
    }
}

