/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.colordata;

import de.p2tools.p2lib.colordata.P2ColorData;
import de.p2tools.p2lib.configfile.pdata.P2Data;
import de.p2tools.p2lib.configfile.pdata.P2DataList;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.scene.paint.Color;

public class P2ColorList
extends SimpleListProperty<P2ColorData>
implements P2DataList<P2ColorData> {
    public static final String TAG = "pColorList";
    private static P2ColorList instance;

    public P2ColorList() {
        super(FXCollections.observableArrayList());
    }

    public static final synchronized P2ColorList getInst() {
        return instance == null ? (instance = new P2ColorList()) : instance;
    }

    public static void resetAllColor() {
        P2ColorList.getInst().forEach(P2ColorData::resetColor);
    }

    public static void resetAllColorDarkLight() {
        P2ColorList.getInst().forEach(P2ColorData::resetColorDarkLight);
    }

    public static P2ColorData get(String key) {
        P2ColorList.getInst();
        return P2ColorList.get(key);
    }

    public static synchronized P2ColorData addNewKey(String key, Color color, String text) {
        P2ColorData c = new P2ColorData(key, color, color, true, text);
        P2ColorList.getInst().add(c);
        return c;
    }

    public static synchronized P2ColorData addNewKey(String key, Color color, Color colorDark, String text) {
        P2ColorData c = new P2ColorData(key, color, colorDark, true, text);
        P2ColorList.getInst().add(c);
        return c;
    }

    public static synchronized P2ColorData addNewKey(String key, Color color, Color colorDark, boolean use, String text) {
        P2ColorData c = new P2ColorData(key, color, colorDark, use, text);
        P2ColorList.getInst().add(c);
        return c;
    }

    public static synchronized P2ColorData addNewKey(String key, Color color, Color colorDark, boolean use, String text, int mark) {
        P2ColorData c = new P2ColorData(key, color, colorDark, use, text);
        c.setMark(mark);
        P2ColorList.getInst().add(c);
        return c;
    }

    @Override
    public String getTag() {
        return TAG;
    }

    @Override
    public String getComment() {
        return "Liste aller Farben";
    }

    @Override
    public P2Data getNewItem() {
        return new P2ColorData();
    }

    @Override
    public void addNewItem(Object obj) {
        if (obj.getClass().equals(P2ColorData.class)) {
            this.stream().forEach(p -> {
                if (p.getKey().equals(((P2ColorData)obj).getKey())) {
                    p.setColorLight(((P2ColorData)obj).getColorLight());
                    p.setColorDark(((P2ColorData)obj).getColorDark());
                    p.setUse(((P2ColorData)obj).isUse());
                }
            });
        }
    }
}

