/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.alert;

import de.p2tools.p2lib.alert.P2Alert;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.DialogPane;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.text.TextFlow;
import javafx.stage.Stage;

public class P2AlertWorker {
    static boolean alertOkCancel(Stage stage, String title, String header, String content) {
        Alert alert = P2AlertWorker.getAlert(stage, Alert.AlertType.CONFIRMATION, title, header);
        alert.setContentText(content);
        Optional bt = alert.showAndWait();
        return bt.isPresent() && bt.get() == ButtonType.OK;
    }

    static P2Alert.BUTTON alert_yes_no(Stage stage, String title, String header, String content) {
        Alert alert = P2AlertWorker.getAlert(stage, Alert.AlertType.CONFIRMATION, title, header);
        alert.setContentText(content);
        ButtonType btnYes = new ButtonType("Ja", ButtonBar.ButtonData.YES);
        ButtonType btnNo = new ButtonType("Nein", ButtonBar.ButtonData.NO);
        alert.getButtonTypes().setAll((ButtonType[])new ButtonType[]{btnYes, btnNo});
        ((Button)alert.getDialogPane().lookupButton(btnYes)).setDefaultButton(true);
        ((Button)alert.getDialogPane().lookupButton(btnNo)).setDefaultButton(false);
        P2Alert.BUTTON ret = P2Alert.BUTTON.NO;
        Optional result = alert.showAndWait();
        if (result.get() == btnYes) {
            ret = P2Alert.BUTTON.YES;
        } else if (result.get() == btnNo) {
            ret = P2Alert.BUTTON.NO;
        }
        return ret;
    }

    static P2Alert.BUTTON alert_yes_no_remember(Stage stage, String title, String header, String content, BooleanProperty remember) {
        Alert alert = P2AlertWorker.getAlert(stage, Alert.AlertType.CONFIRMATION, title, header);
        alert.setContentText(content);
        ButtonType btnYes = new ButtonType("Ja", ButtonBar.ButtonData.YES);
        ButtonType btnNo = new ButtonType("Nein", ButtonBar.ButtonData.NO);
        alert.getButtonTypes().setAll((ButtonType[])new ButtonType[]{btnYes, btnNo});
        ((Button)alert.getDialogPane().lookupButton(btnYes)).setDefaultButton(true);
        ((Button)alert.getDialogPane().lookupButton(btnNo)).setDefaultButton(false);
        P2Alert.BUTTON ret = P2Alert.BUTTON.NO;
        Optional result = alert.showAndWait();
        if (result.get() == btnYes) {
            ret = P2Alert.BUTTON.YES;
        } else if (result.get() == btnNo) {
            ret = P2Alert.BUTTON.NO;
        }
        return ret;
    }

    public static P2Alert.BUTTON alert_yes_no_remember(Stage stage, String title, String header, String content, final BooleanProperty remember, final String optOutMsg) {
        Alert alert = P2AlertWorker.getAlert(stage, Alert.AlertType.CONFIRMATION, title, header);
        alert.getDialogPane().applyCss();
        Node graphic = alert.getDialogPane().getGraphic();
        alert.setDialogPane(new DialogPane(){

            @Override
            protected Node createDetailsButton() {
                CheckBox chkOptOut = new CheckBox();
                chkOptOut.setText(optOutMsg);
                chkOptOut.selectedProperty().bindBidirectional(remember);
                return chkOptOut;
            }
        });
        alert.getDialogPane().setExpandableContent(new Group());
        alert.getDialogPane().setExpanded(true);
        alert.getDialogPane().setGraphic(graphic);
        alert.setTitle(title);
        alert.setHeaderText(header);
        alert.getDialogPane().setContentText(content);
        ButtonType btnYes = new ButtonType("Ja", ButtonBar.ButtonData.YES);
        ButtonType btnNo = new ButtonType("Nein", ButtonBar.ButtonData.NO);
        alert.getButtonTypes().setAll((ButtonType[])new ButtonType[]{btnYes, btnNo});
        ((Button)alert.getDialogPane().lookupButton(btnYes)).setDefaultButton(true);
        ((Button)alert.getDialogPane().lookupButton(btnNo)).setDefaultButton(false);
        P2Alert.BUTTON ret = P2Alert.BUTTON.NO;
        Optional result = alert.showAndWait();
        if (result.get() == btnYes) {
            ret = P2Alert.BUTTON.YES;
        } else if (result.get() == btnNo) {
            ret = P2Alert.BUTTON.NO;
        }
        return ret;
    }

    static P2Alert.BUTTON alert_yes_no_cancel(Stage stage, String title, String header, String content, boolean noBtn) {
        Alert alert = P2AlertWorker.getAlert(stage, Alert.AlertType.CONFIRMATION, title, header);
        alert.setContentText(content);
        ButtonType btnYes = new ButtonType("Ja", ButtonBar.ButtonData.YES);
        ButtonType btnNo = new ButtonType("Nein", ButtonBar.ButtonData.NO);
        ButtonType btnCancel = new ButtonType("Abbrechen", ButtonBar.ButtonData.CANCEL_CLOSE);
        if (noBtn) {
            alert.getButtonTypes().setAll((ButtonType[])new ButtonType[]{btnYes, btnNo, btnCancel});
        } else {
            alert.getButtonTypes().setAll((ButtonType[])new ButtonType[]{btnYes, btnCancel});
        }
        ((Button)alert.getDialogPane().lookupButton(btnYes)).setDefaultButton(false);
        ((Button)alert.getDialogPane().lookupButton(btnCancel)).setDefaultButton(true);
        P2Alert.BUTTON ret = P2Alert.BUTTON.CANCEL;
        Optional result = alert.showAndWait();
        if (result.get() == btnYes) {
            ret = P2Alert.BUTTON.YES;
        } else if (result.get() == btnNo) {
            ret = P2Alert.BUTTON.NO;
        } else if (result.get() == btnCancel) {
            ret = P2Alert.BUTTON.CANCEL;
        }
        return ret;
    }

    static P2Alert.BUTTON alert_yes_no_cancel(Stage stage, String title, String header, String content, boolean noBtn, String yesButton, String noButton) {
        Alert alert = P2AlertWorker.getAlert(stage, Alert.AlertType.CONFIRMATION, title, header);
        alert.setContentText(content);
        ButtonType btnYes = new ButtonType(yesButton, ButtonBar.ButtonData.YES);
        ButtonType btnNo = new ButtonType(noButton, ButtonBar.ButtonData.NO);
        ButtonType btnCancel = new ButtonType("Abbrechen", ButtonBar.ButtonData.CANCEL_CLOSE);
        if (noBtn) {
            alert.getButtonTypes().setAll((ButtonType[])new ButtonType[]{btnYes, btnNo, btnCancel});
        } else {
            alert.getButtonTypes().setAll((ButtonType[])new ButtonType[]{btnYes, btnCancel});
        }
        ((Button)alert.getDialogPane().lookupButton(btnYes)).setDefaultButton(false);
        ((Button)alert.getDialogPane().lookupButton(btnCancel)).setDefaultButton(true);
        P2Alert.BUTTON ret = P2Alert.BUTTON.CANCEL;
        Optional result = alert.showAndWait();
        if (result.get() == btnYes) {
            ret = P2Alert.BUTTON.YES;
        } else if (result.get() == btnNo) {
            ret = P2Alert.BUTTON.NO;
        } else if (result.get() == btnCancel) {
            ret = P2Alert.BUTTON.CANCEL;
        }
        return ret;
    }

    static P2Alert.BUTTON alert_yes_no_cancel(Stage stage, String title, String header, TextFlow content, boolean noBtn) {
        Alert alert = P2AlertWorker.getAlert(stage, Alert.AlertType.CONFIRMATION, title, header);
        alert.getDialogPane().setContent(content);
        ButtonType btnYes = new ButtonType("Ja", ButtonBar.ButtonData.YES);
        ButtonType btnNo = new ButtonType("Nein", ButtonBar.ButtonData.NO);
        ButtonType btnCancel = new ButtonType("Abbrechen", ButtonBar.ButtonData.CANCEL_CLOSE);
        if (noBtn) {
            alert.getButtonTypes().setAll((ButtonType[])new ButtonType[]{btnYes, btnNo, btnCancel});
        } else {
            alert.getButtonTypes().setAll((ButtonType[])new ButtonType[]{btnYes, btnCancel});
        }
        ((Button)alert.getDialogPane().lookupButton(btnYes)).setDefaultButton(false);
        ((Button)alert.getDialogPane().lookupButton(btnCancel)).setDefaultButton(true);
        P2Alert.BUTTON ret = P2Alert.BUTTON.CANCEL;
        Optional result = alert.showAndWait();
        if (result.get() == btnYes) {
            ret = P2Alert.BUTTON.YES;
        } else if (result.get() == btnNo) {
            ret = P2Alert.BUTTON.NO;
        } else if (result.get() == btnCancel) {
            ret = P2Alert.BUTTON.CANCEL;
        }
        return ret;
    }

    static boolean helpAlert(Stage stage, String header, TextFlow content) {
        Alert alert = P2AlertWorker.getAlert(stage, Alert.AlertType.INFORMATION, "Hilfe", header);
        alert.getDialogPane().setContent(content);
        Optional bt = alert.showAndWait();
        return bt.isPresent() && bt.get() == ButtonType.OK;
    }

    static boolean helpAlert(Stage stage, String header, String content) {
        Alert alert = P2AlertWorker.getAlert(stage, Alert.AlertType.INFORMATION, "Hilfe", header);
        ScrollPane scroll = new ScrollPane();
        TextArea ta = new TextArea(content);
        ta.setEditable(false);
        ta.setWrapText(true);
        scroll.setContent(ta);
        scroll.setFitToHeight(true);
        scroll.setFitToWidth(true);
        alert.getDialogPane().setContent(scroll);
        Optional bt = alert.showAndWait();
        return bt.isPresent() && bt.get() == ButtonType.OK;
    }

    static boolean infoAlert(Stage stage, String title, String header, String content, boolean txtArea) {
        Alert alert = P2AlertWorker.getAlert(stage, Alert.AlertType.INFORMATION, title, header);
        if (txtArea) {
            ScrollPane scroll = new ScrollPane();
            TextArea ta = new TextArea(content);
            ta.setEditable(false);
            scroll.setContent(ta);
            scroll.setFitToHeight(true);
            scroll.setFitToWidth(true);
            alert.getDialogPane().setContent(scroll);
        } else {
            alert.setContentText(content);
        }
        Optional bt = alert.showAndWait();
        return bt.isPresent() && bt.get() == ButtonType.OK;
    }

    static boolean errorAlert(Stage stage, String title, String header, String content) {
        Alert alert = P2AlertWorker.getAlert(stage, Alert.AlertType.ERROR, title, header);
        alert.setContentText(content);
        Optional bt = alert.showAndWait();
        return bt.isPresent() && bt.get() == ButtonType.OK;
    }

    static boolean infoNoSelection(Stage stage) {
        Alert alert = P2AlertWorker.getAlert(stage, Alert.AlertType.INFORMATION, "keine Auswahl", "Es wurde nichts markiert.");
        alert.setContentText("Zeile ausw\u00e4hlen!");
        Optional bt = alert.showAndWait();
        return bt.isPresent() && bt.get() == ButtonType.OK;
    }

    private static Alert getAlert(Stage stage, Alert.AlertType alertType, String title, String header) {
        Alert alert = new Alert(alertType);
        if (stage != null) {
            alert.initOwner(stage);
        }
        alert.setTitle(title);
        alert.setHeaderText(header);
        alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
        return alert;
    }
}

