/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.startdialog;

import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2podder.controller.ProgIcons;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.gui.startdialog.ConfigPane;
import de.p2tools.p2podder.gui.startdialog.StartPane;
import de.p2tools.p2podder.gui.startdialog.StartPaneColorMode;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;

public class StartDialogController
extends P2DialogExtra {
    private boolean ok = false;
    private final TilePane tilePane = new TilePane();
    private Button btnOk;
    private Button btnCancel;
    private Button btnPrev;
    private Button btnNext;
    private final Button btnDescription = new Button("Infos");
    private final Button btnStart1 = new Button("Infos");
    private final Button btnStart2 = new Button("Infos");
    private final Button btnStart3 = new Button("Infos");
    private final Button btnColor = new Button("Farbe");
    private final Button btnConfig = new Button("Einstellungen");
    private static final String STR_START = "Infos";
    private static final String STR_COLOR = "Farbe";
    private static final String STR_CONFIG = "Einstellungen";
    private State aktState = State.START_DESCRIPTION;
    private TitledPane tStartDescription;
    private TitledPane tStart1;
    private TitledPane tStart2;
    private TitledPane tStart3;
    private TitledPane tColor;
    private TitledPane tConfig;
    private StartPane startDescription;
    private StartPane startPane1;
    private StartPane startPane2;
    private StartPane startPane3;
    private StartPaneColorMode colorPane;
    private ConfigPane configPane;
    private final ProgData progData = ProgData.getInstance();

    public StartDialogController() {
        super(null, null, "Starteinstellungen", true, false);
        this.init(true);
    }

    @Override
    public void make() {
        this.initTopButton();
        this.initStack();
        this.initButton();
        this.initTooltip();
        this.selectActPane();
    }

    private void closeDialog(boolean ok) {
        this.ok = ok;
        this.startDescription.close();
        this.startPane1.close();
        this.startPane2.close();
        this.startPane3.close();
        this.colorPane.close();
        this.configPane.close();
        super.close();
    }

    public boolean isOk() {
        return this.ok;
    }

    private void initTopButton() {
        this.getVBoxCont().getChildren().add(this.tilePane);
        this.tilePane.getChildren().addAll((Node[])new Node[]{this.btnDescription, this.btnStart1, this.btnStart2, this.btnStart3, this.btnColor, this.btnConfig});
        this.tilePane.setAlignment(Pos.CENTER);
        this.tilePane.setPadding(new Insets(10.0, 10.0, 20.0, 10.0));
        this.tilePane.setHgap(10.0);
        this.tilePane.setVgap(10.0);
        this.initButton(this.btnDescription, State.START_DESCRIPTION);
        this.initButton(this.btnStart1, State.START_1);
        this.initButton(this.btnStart2, State.START_2);
        this.initButton(this.btnStart3, State.START_3);
        this.initButton(this.btnColor, State.COLOR);
        this.initButton(this.btnConfig, State.CONFIG);
    }

    private void initButton(Button btn, State state) {
        btn.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFuncStartDialog"});
        btn.setMaxWidth(Double.MAX_VALUE);
        btn.setAlignment(Pos.CENTER);
        btn.setOnAction(a -> {
            this.aktState = state;
            this.selectActPane();
        });
    }

    private void initStack() {
        StackPane stackpane = new StackPane();
        VBox.setVgrow(stackpane, Priority.ALWAYS);
        this.getVBoxCont().getChildren().add(stackpane);
        this.startDescription = new StartPane(this.getStage());
        this.tStartDescription = this.startDescription.makeDescription();
        this.tStartDescription.setMaxHeight(Double.MAX_VALUE);
        this.tStartDescription.setCollapsible(false);
        this.startPane1 = new StartPane(this.getStage());
        this.tStart1 = this.startPane1.makeStart1();
        this.tStart1.setMaxHeight(Double.MAX_VALUE);
        this.tStart1.setCollapsible(false);
        this.startPane2 = new StartPane(this.getStage());
        this.tStart2 = this.startPane2.makeStart2();
        this.tStart2.setMaxHeight(Double.MAX_VALUE);
        this.tStart2.setCollapsible(false);
        this.startPane3 = new StartPane(this.getStage());
        this.tStart3 = this.startPane3.makeStart3();
        this.tStart3.setMaxHeight(Double.MAX_VALUE);
        this.tStart3.setCollapsible(false);
        this.colorPane = new StartPaneColorMode(this.getStage());
        this.tColor = this.colorPane.make();
        this.tColor.setMaxHeight(Double.MAX_VALUE);
        this.tColor.setCollapsible(false);
        this.configPane = new ConfigPane(this.getStage());
        this.tConfig = this.configPane.makeStart();
        this.tConfig.setMaxHeight(Double.MAX_VALUE);
        this.tConfig.setCollapsible(false);
        stackpane.getChildren().addAll((Node[])new Node[]{this.tStartDescription, this.tStart1, this.tStart2, this.tStart3, this.tColor, this.tConfig});
    }

    private void initButton() {
        this.btnOk = new Button("_Ok");
        this.btnOk.setDisable(true);
        this.btnOk.setOnAction(a -> this.closeDialog(true));
        this.btnCancel = new Button("_Abbrechen");
        this.btnCancel.setOnAction(a -> this.closeDialog(false));
        this.btnNext = P2Button.getButton(ProgIcons.ICON_BUTTON_NEXT.getImageView(), "n\u00e4chste Seite");
        this.btnNext.setOnAction(event -> {
            switch (this.aktState) {
                case START_DESCRIPTION: {
                    this.aktState = State.START_1;
                    break;
                }
                case START_1: {
                    this.aktState = State.START_2;
                    break;
                }
                case START_2: {
                    this.aktState = State.START_3;
                    break;
                }
                case START_3: {
                    this.aktState = State.COLOR;
                    break;
                }
                case COLOR: {
                    this.aktState = State.CONFIG;
                    break;
                }
            }
            this.selectActPane();
        });
        this.btnPrev = P2Button.getButton(ProgIcons.ICON_BUTTON_PREV.getImageView(), "vorherige Seite");
        this.btnPrev.setOnAction(event -> {
            switch (this.aktState) {
                case START_DESCRIPTION: {
                    break;
                }
                case START_1: {
                    this.aktState = State.START_DESCRIPTION;
                    break;
                }
                case START_2: {
                    this.aktState = State.START_1;
                    break;
                }
                case START_3: {
                    this.aktState = State.START_2;
                    break;
                }
                case COLOR: {
                    this.aktState = State.START_3;
                    break;
                }
                case CONFIG: {
                    this.aktState = State.COLOR;
                }
            }
            this.selectActPane();
        });
        this.addOkCancelButtons(this.btnOk, this.btnCancel);
        ButtonBar.setButtonData(this.btnPrev, ButtonBar.ButtonData.BACK_PREVIOUS);
        ButtonBar.setButtonData(this.btnNext, ButtonBar.ButtonData.NEXT_FORWARD);
        this.addAnyButton(this.btnNext);
        this.addAnyButton(this.btnPrev);
        this.getButtonBar().setButtonOrder("BX+CO");
    }

    private void selectActPane() {
        switch (this.aktState) {
            case START_DESCRIPTION: {
                this.btnPrev.setDisable(true);
                this.btnNext.setDisable(false);
                this.tStartDescription.toFront();
                this.setButtonStyle(this.btnDescription);
                break;
            }
            case START_1: {
                this.btnPrev.setDisable(false);
                this.btnNext.setDisable(false);
                this.tStart1.toFront();
                this.setButtonStyle(this.btnStart1);
                break;
            }
            case START_2: {
                this.btnPrev.setDisable(false);
                this.btnNext.setDisable(false);
                this.tStart2.toFront();
                this.setButtonStyle(this.btnStart2);
                break;
            }
            case START_3: {
                this.btnPrev.setDisable(false);
                this.btnNext.setDisable(false);
                this.tStart3.toFront();
                this.setButtonStyle(this.btnStart3);
                break;
            }
            case COLOR: {
                this.btnPrev.setDisable(false);
                this.btnNext.setDisable(false);
                this.tColor.toFront();
                this.setButtonStyle(this.btnColor);
                break;
            }
            case CONFIG: {
                this.btnPrev.setDisable(false);
                this.btnNext.setDisable(true);
                this.tConfig.toFront();
                this.setButtonStyle(this.btnConfig);
                this.btnOk.setDisable(false);
                break;
            }
            default: {
                this.btnOk.setDisable(false);
            }
        }
    }

    private void setButtonStyle(Button btnSel) {
        this.btnDescription.getStyleClass().setAll((String[])new String[]{"btnFunction", "btnFuncStartDialog"});
        this.btnStart1.getStyleClass().setAll((String[])new String[]{"btnFunction", "btnFuncStartDialog"});
        this.btnStart2.getStyleClass().setAll((String[])new String[]{"btnFunction", "btnFuncStartDialog"});
        this.btnStart3.getStyleClass().setAll((String[])new String[]{"btnFunction", "btnFuncStartDialog"});
        this.btnColor.getStyleClass().setAll((String[])new String[]{"btnFunction", "btnFuncStartDialog"});
        this.btnConfig.getStyleClass().setAll((String[])new String[]{"btnFunction", "btnFuncStartDialog"});
        btnSel.getStyleClass().setAll((String[])new String[]{"btnFunction", "btnFuncStartDialogSel"});
    }

    private void initTooltip() {
        this.btnDescription.setTooltip(new Tooltip("Infos \u00fcber das Programm"));
        this.btnStart1.setTooltip(new Tooltip("Infos \u00fcber das Programm"));
        this.btnStart2.setTooltip(new Tooltip("Infos \u00fcber das Programm"));
        this.btnStart3.setTooltip(new Tooltip("Infos \u00fcber das Programm"));
        this.btnColor.setTooltip(new Tooltip("Farbe der Programmoberfl\u00e4che"));
        this.btnConfig.setTooltip(new Tooltip("Einstellungen des Programms?"));
        this.btnOk.setTooltip(new Tooltip("Programm mit den gew\u00e4hlten Einstellungen starten"));
        this.btnCancel.setTooltip(new Tooltip("Das Programm nicht einrichten\nund starten sondern Dialog wieder beenden"));
        this.btnNext.setTooltip(new Tooltip("N\u00e4chste Einstellm\u00f6glichkeit"));
        this.btnPrev.setTooltip(new Tooltip("Vorherige Einstellm\u00f6glichkeit"));
    }

    private static enum State {
        START_DESCRIPTION,
        START_1,
        START_2,
        START_3,
        COLOR,
        CONFIG;

    }
}

