/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.smallgui;

import de.p2tools.p2lib.dialogs.dialog.P2DialogOnly;
import de.p2tools.p2lib.p2event.P2Event;
import de.p2tools.p2lib.p2event.P2Listener;
import de.p2tools.p2podder.controller.config.PEvents;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.episode.Episode;
import de.p2tools.p2podder.gui.smallgui.SmallGuiBottom;
import de.p2tools.p2podder.gui.smallgui.SmallGuiCenter;
import de.p2tools.p2podder.gui.smallgui.SmallGuiHelpDialogController;
import de.p2tools.p2podder.gui.smallgui.SmallGuiTop;
import java.util.ArrayList;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class SmallGuiPack
extends P2DialogOnly {
    private final SmallGuiTop smallGuiTop;
    private final SmallGuiCenter smallGuiCenter;
    private final SmallGuiBottom smallGuiBottom;
    private final ProgData progData;
    private final P2Listener listener = new P2Listener(PEvents.EVENT_REFRESH_TABLE){

        public void pingGui(P2Event event) {
            SmallGuiPack.this.tableRefresh();
        }
    };

    public SmallGuiPack() {
        super(ProgData.getInstance().primaryStage, ProgConfig.SMALL_PODDER_SIZE, "Podder", false, false, true);
        this.progData = ProgData.getInstance();
        this.smallGuiTop = new SmallGuiTop(this);
        this.smallGuiCenter = new SmallGuiCenter(this);
        this.smallGuiBottom = new SmallGuiBottom(this);
        this.progData.smallGuiPack = this;
        this.init(false);
        if (!ProgConfig.SYSTEM_SMALL_GUI_SHOW_START_HELP.getValue().booleanValue()) {
            new SmallGuiHelpDialogController(ProgData.getInstance().primaryStage);
            ProgConfig.SYSTEM_SMALL_GUI_SHOW_START_HELP.setValue(true);
        }
    }

    @Override
    public void make() {
        VBox vAll = this.getVBoxCompleteDialog();
        vAll.getChildren().addAll((Node[])new Node[]{this.smallGuiTop, this.smallGuiCenter, this.smallGuiBottom});
        VBox.setVgrow(this.smallGuiCenter, Priority.ALWAYS);
        VBox.setVgrow(super.getVBoxCompleteDialog(), Priority.ALWAYS);
        this.progData.pEventHandler.addListener(this.listener);
        this.getStage().getScene().addEventHandler(KeyEvent.KEY_PRESSED, keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ESCAPE) {
                this.close();
            }
        });
        this.getStage().setOnCloseRequest(e -> {
            e.consume();
            this.close();
        });
    }

    @Override
    public void close() {
        this.saveTable();
        this.progData.smallGuiPack = null;
        ProgConfig.SYSTEM_SMALL_PODDER.setValue(false);
        super.close();
    }

    private void saveTable() {
        this.smallGuiCenter.saveTable();
    }

    public void tableRefresh() {
        this.smallGuiCenter.tableRefresh();
    }

    public void clearFilter() {
        this.smallGuiTop.clearFilter();
    }

    public void playEpisode() {
        this.smallGuiCenter.playEpisode();
    }

    public ArrayList<Episode> getSelList() {
        return this.smallGuiCenter.getSelList();
    }

    public Optional<Episode> getSel() {
        return this.smallGuiCenter.getSel();
    }

    public void setNextEpisode() {
        this.smallGuiCenter.setNextEpisode();
    }

    public void setPreviousEpisode() {
        this.smallGuiCenter.setPreviousEpisode();
    }

    public void playRandomStation() {
        this.smallGuiCenter.playRandomStation();
    }

    public void setEpisodeInfoBox(Episode episode) {
        this.smallGuiBottom.setInfoBox(episode);
    }
}

