/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.smallgui;

import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2lib.tools.date.P2LDateFactory;
import de.p2tools.p2podder.controller.ProgIcons;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.episode.Episode;
import de.p2tools.p2podder.controller.data.episode.EpisodeFactory;
import de.p2tools.p2podder.gui.smallgui.SmallGuiPack;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Separator;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

public class SmallGuiBottom
extends VBox {
    private final RadioButton rbAll = new RadioButton("alle");
    private final RadioButton rbStarted = new RadioButton("gestartete");
    private final RadioButton rbRunning = new RadioButton("l\u00e4uft");
    private final RadioButton rbWasShown = new RadioButton("geh\u00f6rte");
    private final RadioButton rbNew = new RadioButton("neue");
    private final Button btnRandom = new Button("");
    private final Button btnNext = new Button("");
    private final Button btnPrev = new Button("");
    private final Button btnStart = new Button("");
    private final Button btnPlayNext = new Button("");
    private final Button btnStop = new Button("");
    private final Label lblDate = new Label("");
    private final Label lblPodcast = new Label("");
    private final Label lblTitle = new Label("");
    private final SmallGuiPack smallGuiPack;
    private final ProgData progData;

    public SmallGuiBottom(SmallGuiPack smallGuiPack) {
        this.smallGuiPack = smallGuiPack;
        this.progData = ProgData.getInstance();
        this.init();
        this.initStartButton();
    }

    public void init() {
        this.setAlignment(Pos.CENTER);
        ToggleGroup tg = new ToggleGroup();
        this.rbAll.setToggleGroup(tg);
        this.rbStarted.setToggleGroup(tg);
        this.rbRunning.setToggleGroup(tg);
        this.rbWasShown.setToggleGroup(tg);
        this.rbNew.setToggleGroup(tg);
        Separator sp1 = new Separator(Orientation.VERTICAL);
        sp1.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
        Separator sp2 = new Separator(Orientation.VERTICAL);
        sp1.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
        Separator sp3 = new Separator(Orientation.VERTICAL);
        sp2.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
        HBox hBoxButton = new HBox(5.0);
        hBoxButton.setAlignment(Pos.CENTER_RIGHT);
        hBoxButton.getChildren().addAll((Node[])new Node[]{new Label("Episoden: "), this.rbAll, this.rbNew, this.rbStarted, this.rbRunning, this.rbWasShown, P2GuiTools.getHBoxGrower(), this.btnRandom, sp2, this.btnPrev, this.btnNext, sp3, this.btnStart, this.btnPlayNext, this.btnStop});
        this.getChildren().addAll((Node[])new Node[]{hBoxButton});
        this.initFilter();
    }

    private GridPane getInfoBox() {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(20.0);
        gridPane.setPadding(new Insets(0.0));
        gridPane.add(this.lblTitle, 0, 0);
        gridPane.add(this.lblDate, 1, 0);
        return gridPane;
    }

    void setInfoBox(Episode episode) {
        if (episode == null) {
            this.lblDate.setText("");
            this.lblPodcast.setText("");
            this.lblTitle.setText("");
        } else {
            String date = P2LDateFactory.toString(episode.getPubDate());
            String dur = episode.getDurationStr();
            if (!date.isEmpty() && !dur.isEmpty()) {
                this.lblDate.setText(date + "  /  " + dur);
            } else {
                this.lblDate.setText(date + dur);
            }
            this.lblPodcast.setText(episode.getPodcastName());
            this.lblTitle.setText(episode.getEpisodeTitle());
        }
    }

    private void initStartButton() {
        this.btnRandom.setTooltip(new Tooltip("Eine Episode per Zufall starten"));
        this.btnRandom.getStyleClass().add("btnSmallGui");
        this.btnRandom.setGraphic(ProgIcons.ICON_BUTTON_RANDOM.getImageView());
        this.btnRandom.setOnAction(event -> this.smallGuiPack.playRandomStation());
        this.btnPrev.setTooltip(new Tooltip("vorherige Episode ausw\u00e4hlen"));
        this.btnPrev.getStyleClass().add("btnSmallGui");
        this.btnPrev.setGraphic(ProgIcons.ICON_BUTTON_PREV.getImageView());
        this.btnPrev.setOnAction(event -> this.smallGuiPack.setPreviousEpisode());
        this.btnNext.setTooltip(new Tooltip("n\u00e4chste Episode ausw\u00e4hlen"));
        this.btnNext.getStyleClass().add("btnSmallGui");
        this.btnNext.setGraphic(ProgIcons.ICON_BUTTON_NEXT.getImageView());
        this.btnNext.setOnAction(event -> this.smallGuiPack.setNextEpisode());
        this.btnStart.setTooltip(new Tooltip("Markierte Episoden abspielen"));
        this.btnStart.getStyleClass().add("btnSmallGui");
        this.btnStart.setGraphic(ProgIcons.ICON_BUTTON_PLAY.getImageView());
        this.btnStart.setOnAction(event -> this.smallGuiPack.playEpisode());
        this.btnPlayNext.setTooltip(new Tooltip("N\u00e4chste gestartete Episode abspielen"));
        this.btnPlayNext.getStyleClass().add("btnSmallGui");
        this.btnPlayNext.setGraphic(ProgIcons.ICON_BUTTON_PLAY_NEXT.getImageView());
        this.btnPlayNext.setOnAction(event -> EpisodeFactory.playNextEpisode(this.progData.smallGuiPack.getStage()));
        this.btnStop.setTooltip(new Tooltip("alle laufenden Episoden stoppen"));
        this.btnStop.getStyleClass().add("btnSmallGui");
        this.btnStop.setGraphic(ProgIcons.ICON_BUTTON_STOP.getImageView());
        this.btnStop.setOnAction(event -> EpisodeFactory.stopAllEpisode());
    }

    private void initFilter() {
        this.rbAll.selectedProperty().bindBidirectional(this.progData.episodeFilterSmall.isAllProperty());
        this.rbNew.selectedProperty().bindBidirectional(this.progData.episodeFilterSmall.isNewProperty());
        this.rbStarted.selectedProperty().bindBidirectional(this.progData.episodeFilterSmall.isStartedProperty());
        this.rbRunning.selectedProperty().bindBidirectional(this.progData.episodeFilterSmall.isRunningProperty());
        this.rbWasShown.selectedProperty().bindBidirectional(this.progData.episodeFilterSmall.wasShownProperty());
    }
}

