/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.podcastadd;

import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2podder.controller.ProgQuitFactory;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.podcast.Podcast;
import de.p2tools.p2podder.gui.podcastadd.AddPodcastData;
import de.p2tools.p2podder.gui.podcastadd.AddPodcastDto;
import de.p2tools.p2podder.gui.podcastadd.PodcastAddDialogGui;
import java.util.ArrayList;
import javafx.scene.control.Button;

public class PodcastAddDialogController
extends P2DialogExtra {
    private final ProgData progData;
    private final Button btnOk = new Button("_Ok");
    private final Button btnCancel = new Button("_Abbrechen");
    private boolean ok = false;
    private final boolean setAll;
    private final AddPodcastDto addPodcastDto;

    public PodcastAddDialogController(ProgData progData, ArrayList<Podcast> list, boolean addNew) {
        super(progData.primaryStage, list.size() > 1 ? ProgConfig.PODCAST_DIALOG_ADD_MORE_SIZE : ProgConfig.PODCAST_DIALOG_ADD_SIZE, addNew ? "Podcast anlegen" : "Podcast \u00e4ndern", true, false, P2DialogExtra.DECO.BORDER_SMALL);
        this.progData = progData;
        this.setAll = true;
        this.addPodcastDto = new AddPodcastDto(progData, list, addNew);
        this.initAll();
        this.init(true);
    }

    @Override
    public void make() {
        this.initGui();
        this.initButton();
        this.addPodcastDto.updateAct();
    }

    private void initAll() {
        if (!this.setAll) {
            this.addPodcastDto.chkMaxAgeAll.setSelected(true);
        }
    }

    private void initGui() {
        PodcastAddDialogGui podcastAddDialogGui = new PodcastAddDialogGui(this.addPodcastDto, this.getVBoxCont());
        podcastAddDialogGui.addCont();
        podcastAddDialogGui.init();
        this.addOkCancelButtons(this.btnOk, this.btnCancel);
    }

    private void initButton() {
        this.addPodcastDto.btnPrev.setOnAction(event -> {
            this.addPodcastDto.actFilmIsShown.setValue(this.addPodcastDto.actFilmIsShown.getValue() - 1);
            this.addPodcastDto.updateAct();
        });
        this.addPodcastDto.btnNext.setOnAction(event -> {
            this.addPodcastDto.actFilmIsShown.setValue(this.addPodcastDto.actFilmIsShown.getValue() + 1);
            this.addPodcastDto.updateAct();
        });
        this.btnOk.setOnAction(event -> {
            if (this.check()) {
                this.quit();
            }
        });
        this.btnCancel.setOnAction(event -> {
            this.ok = false;
            this.quit();
        });
    }

    private boolean check() {
        this.ok = false;
        for (AddPodcastData d : this.addPodcastDto.addPodcastData) {
            if (d.podcast == null) {
                P2Alert.showErrorAlert("Fehlerhafter Download!", "Fehlerhafter Download!", "Download konnte nicht erstellt werden.");
                continue;
            }
            this.ok = true;
        }
        return this.ok;
    }

    private void quit() {
        if (!this.ok) {
            this.close();
            return;
        }
        if (this.addPodcastDto.addNewDownloads) {
            this.addNewPodcasts();
        } else {
            this.changePodcasts();
        }
        ProgQuitFactory.saveAll();
        this.progData.podcastGui.getPodcastGuiController().tableRefresh();
        this.close();
    }

    private void addNewPodcasts() {
        ArrayList<Podcast> list = new ArrayList<Podcast>();
        for (AddPodcastData addPodcastData : this.addPodcastDto.addPodcastData) {
            Podcast podcast = addPodcastData.podcast;
            list.add(podcast);
        }
        this.progData.podcastList.addNewItem(list);
    }

    private void changePodcasts() {
        for (AddPodcastData addPodcastData : this.addPodcastDto.addPodcastData) {
            addPodcastData.podcastOrg.copyToMe(addPodcastData.podcast);
        }
    }
}

