/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.filter;

import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ButtonClearFilterFactory;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2podder.controller.ProgIcons;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.gui.tools.HelpText;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class EpisodeFilterControllerClearFilter
extends HBox {
    private final ProgData progData = ProgData.getInstance();

    public EpisodeFilterControllerClearFilter() {
        super(5.0);
        this.addButton();
    }

    private void addButton() {
        Button btnClearFilter = P2ButtonClearFilterFactory.getPButtonClear();
        Button btnGoBack = new Button("");
        Button btnGoForward = new Button("");
        Button btnHelp = P2Button.helpButton("Filter", HelpText.GUI_STATION_FILTER);
        btnGoBack.setGraphic(ProgIcons.ICON_BUTTON_BACKWARD.getImageView());
        btnGoBack.setOnAction(a -> this.progData.episodeFilter.getEpisodeFilterForwardBackward().goBackward());
        btnGoBack.disableProperty().bind(this.progData.episodeFilter.getEpisodeFilterForwardBackward().backwardProperty().not());
        btnGoBack.setTooltip(new Tooltip("letzte Filtereinstellung wieder herstellen"));
        btnGoForward.setGraphic(ProgIcons.ICON_BUTTON_FORWARD.getImageView());
        btnGoForward.setOnAction(a -> this.progData.episodeFilter.getEpisodeFilterForwardBackward().goForward());
        btnGoForward.disableProperty().bind(this.progData.episodeFilter.getEpisodeFilterForwardBackward().forwardProperty().not());
        btnGoForward.setTooltip(new Tooltip("letzte Filtereinstellung wieder herstellen"));
        btnClearFilter.setGraphic(ProgIcons.ICON_BUTTON_CLEAR_FILTER.getImageView());
        btnClearFilter.setOnAction(a -> this.clearFilter());
        btnClearFilter.setTooltip(new Tooltip("Filter l\u00f6schen"));
        btnGoBack.setMaxHeight(Double.MAX_VALUE);
        btnGoForward.setMaxHeight(Double.MAX_VALUE);
        btnClearFilter.setMaxHeight(Double.MAX_VALUE);
        btnHelp.setMaxHeight(Double.MAX_VALUE);
        HBox hBox = new HBox(5.0);
        hBox.setAlignment(Pos.CENTER_LEFT);
        hBox.getChildren().addAll((Node[])new Node[]{btnGoBack, btnGoForward});
        HBox.setHgrow(hBox, Priority.ALWAYS);
        this.setAlignment(Pos.CENTER_RIGHT);
        this.getChildren().addAll((Node[])new Node[]{hBox, btnClearFilter, btnHelp});
    }

    private void clearFilter() {
        P2Duration.onlyPing("Filter l\u00f6schen");
        this.progData.episodeFilter.clearFilter();
    }
}

