/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.dialog;

import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.ImportSetDataFactory;
import de.p2tools.p2podder.controller.data.SetFactory;
import de.p2tools.p2podder.gui.configdialog.setdata.ControllerSet;
import de.p2tools.p2podder.gui.dialog.DownPathPane;
import de.p2tools.p2podder.gui.dialog.ImportSetDialogPanePath;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class ImportSetDialogController
extends P2DialogExtra {
    private final ProgData progData;
    Button btnCancel = new Button("_Abbrechen");
    Button btnImport = new Button("_Set importieren");
    private boolean im = false;
    private StackPane stackPane;
    private VBox vBoxPath = new VBox();
    private ControllerSet controllerSet;

    public ImportSetDialogController(ProgData progData) {
        super(progData.primaryStage, ProgConfig.CONFIG_DIALOG_IMPORT_SET_SIZE, "Set importieren", true, false, P2DialogExtra.DECO.BORDER_SMALL);
        this.progData = progData;
        this.init(true);
    }

    @Override
    public void close() {
        this.controllerSet.close();
        super.close();
    }

    @Override
    public void make() {
        this.btnCancel.setOnAction(a -> this.close());
        Button btnHelp = P2Button.helpButton("Set zur\u00fccksetzen", "\"Bestehende Sets durch neue ersetzen\"" + P2LibConst.LINE_SEPARATORx2 + "Damit werden alle Sets (auch eigene), die zum Abspielen" + P2LibConst.LINE_SEPARATOR + "der Episoden gebraucht werden, gel\u00f6scht." + P2LibConst.LINE_SEPARATOR + "Anschlie\u00dfend werden die aktuellen Standardsets eingerichtet." + P2LibConst.LINE_SEPARATOR + "Damit kann dann direkt weitergearbeitet werden.");
        this.btnImport.setOnAction(event -> this.importSet());
        TitledPane tpDownPath = new DownPathPane(this.progData.primaryStage).makePath();
        tpDownPath.setMaxHeight(Double.MAX_VALUE);
        tpDownPath.setCollapsible(false);
        TitledPane tpPath = new ImportSetDialogPanePath(this.progData.primaryStage).makePath();
        tpPath.setMaxHeight(Double.MAX_VALUE);
        tpPath.setCollapsible(false);
        this.vBoxPath.setSpacing(10.0);
        this.vBoxPath.getChildren().addAll((Node[])new Node[]{tpDownPath, tpPath});
        this.vBoxPath.setStyle("-fx-background-color: -fx-background;");
        this.controllerSet = new ControllerSet(P2LibConst.primaryStage);
        this.controllerSet.setMaxWidth(Double.MAX_VALUE);
        this.controllerSet.setMaxHeight(Double.MAX_VALUE);
        this.controllerSet.setStyle("-fx-background-color: -fx-background;");
        this.stackPane = new StackPane();
        this.stackPane.getChildren().addAll((Node[])new Node[]{this.vBoxPath, this.controllerSet});
        this.vBoxPath.toFront();
        VBox.setVgrow(this.stackPane, Priority.ALWAYS);
        this.getVBoxCont().getChildren().add(this.stackPane);
        this.addOkButton(this.btnImport);
        this.addCancelButton(this.btnCancel);
        this.addHlpButton(btnHelp);
    }

    private void importSet() {
        this.im = true;
        this.btnCancel.setText("Ok");
        this.btnImport.setDisable(true);
        this.progData.setDataList.clear();
        if (SetFactory.addSetTemplate(ImportSetDataFactory.getStandarset())) {
            P2Alert.showInfoAlert("Set", "Set importieren", "Sets wurden importiert!", false);
        } else {
            P2Alert.showErrorAlert("Set importieren", "Sets konnten nicht importiert werden!");
        }
        this.controllerSet.toFront();
    }
}

