/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.dialog;

import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2GuiSize;
import de.p2tools.p2lib.guitools.P2Hyperlink;
import de.p2tools.p2lib.tools.date.P2LDateFactory;
import de.p2tools.p2podder.controller.ProgIcons;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.episode.Episode;
import de.p2tools.p2podder.controller.data.episode.EpisodeFactory;
import de.p2tools.p2podder.controller.data.episode.EpisodeFieldNames;
import de.p2tools.p2podder.controller.data.podcast.Podcast;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;

public class EpisodeInfoDialogController
extends P2DialogExtra {
    private final int FREE = 220;
    private final Text[] textTitle = new Text[EpisodeFieldNames.MAX_ELEM];
    private final Label[] lblCont = new Label[EpisodeFieldNames.MAX_ELEM];
    private final Button btnUpDown = new Button("");
    private final Button btnNext = new Button("");
    private final Button btnPrev = new Button("");
    private final Button btnStart = new Button("");
    private final Button btnStop = new Button("");
    private final Button btnOk = new Button("_Ok");
    private final ImageView ivNew = new ImageView();
    private final TextArea taDescription = new TextArea();
    private final P2Hyperlink pHyperlinkUrl = new P2Hyperlink("", ProgConfig.SYSTEM_PROG_OPEN_URL);
    private final P2Hyperlink pHyperlinkWebsite = new P2Hyperlink("", ProgConfig.SYSTEM_PROG_OPEN_URL);
    private Episode episode;
    private final ProgData progData;

    public EpisodeInfoDialogController(ProgData progData) {
        super(progData.primaryStage, null, "Episoden-Infos", false, false, P2DialogExtra.DECO.BORDER_SMALL);
        this.progData = progData;
        this.init(false);
    }

    @Override
    public void showDialog() {
        this.setSizeConfiguration(ProgConfig.EPISODE_INFO_DIALOG_SHOW_BIG.get() ? ProgConfig.SYSTEM_SIZE_DIALOG_EPISODE_INFO : ProgConfig.SYSTEM_SIZE_DIALOG_EPISODE_INFO_SMALL);
        P2GuiSize.setSizePos(ProgConfig.EPISODE_INFO_DIALOG_SHOW_BIG.get() ? ProgConfig.SYSTEM_SIZE_DIALOG_EPISODE_INFO : ProgConfig.SYSTEM_SIZE_DIALOG_EPISODE_INFO_SMALL, this.getStage(), null);
        this.getStage().show();
    }

    public void toggleShowInfo() {
        if (this.getStage().isShowing()) {
            this.close();
        } else {
            this.showEpisodeInfo();
        }
    }

    public void showEpisodeInfo() {
        this.showDialog();
    }

    public void setEpisode(Episode episode) {
        this.episode = episode;
        this.setEpisode();
    }

    @Override
    public void make() {
        ProgConfig.SYSTEM_THEME_CHANGED.addListener((u, o, n) -> this.updateCss());
        this.getHboxLeft().getChildren().addAll((Node[])new Node[]{this.btnUpDown, new HBox(), this.btnPrev, this.btnNext, new HBox(), this.btnStart, this.btnStop});
        this.addOkButton(this.btnOk);
        this.btnOk.setOnAction(a -> this.close());
        this.setBtnUpDownToolTip();
        this.btnUpDown.setOnAction(event -> {
            this.setSizeConfiguration(ProgConfig.EPISODE_INFO_DIALOG_SHOW_BIG.get() ? ProgConfig.SYSTEM_SIZE_DIALOG_EPISODE_INFO : ProgConfig.SYSTEM_SIZE_DIALOG_EPISODE_INFO_SMALL);
            if (ProgConfig.EPISODE_INFO_DIALOG_SHOW_BIG.get()) {
                ProgConfig.EPISODE_INFO_DIALOG_SHOW_BIG.setValue(ProgConfig.EPISODE_INFO_DIALOG_SHOW_BIG.getValue() == false);
                this.makePane();
                P2GuiSize.setSize(ProgConfig.SYSTEM_SIZE_DIALOG_EPISODE_INFO_SMALL, this.getStage());
            } else {
                ProgConfig.EPISODE_INFO_DIALOG_SHOW_BIG.setValue(ProgConfig.EPISODE_INFO_DIALOG_SHOW_BIG.getValue() == false);
                this.makePane();
                P2GuiSize.setSize(ProgConfig.SYSTEM_SIZE_DIALOG_EPISODE_INFO, this.getStage());
            }
            this.setBtnUpDownToolTip();
        });
        this.btnPrev.setTooltip(new Tooltip("weniger Informationen zur Episode anzeigen"));
        this.btnPrev.setGraphic(ProgIcons.ICON_BUTTON_PREV.getImageView());
        this.btnPrev.setOnAction(event -> this.progData.episodeGui.getEpisodeGuiController().setPreviousStation());
        this.btnNext.setTooltip(new Tooltip("weniger Informationen zur Episode anzeigen"));
        this.btnNext.setGraphic(ProgIcons.ICON_BUTTON_NEXT.getImageView());
        this.btnNext.setOnAction(event -> this.progData.episodeGui.getEpisodeGuiController().setNextStation());
        this.btnStart.setTooltip(new Tooltip("Episode abspielen"));
        this.btnStart.setGraphic(ProgIcons.ICON_BUTTON_PLAY.getImageView());
        this.btnStart.setOnAction(event -> EpisodeFactory.playEpisode());
        this.btnStop.setTooltip(new Tooltip("alle laufenden Episoden stoppen"));
        this.btnStop.setGraphic(ProgIcons.ICON_BUTTON_STOP.getImageView());
        this.btnStop.setOnAction(event -> EpisodeFactory.stopAllEpisode());
        this.initUrl();
        this.addStageListener();
        this.makePane();
    }

    private void addStageListener() {
        this.getStage().widthProperty().addListener((v, o, n) -> this.addStageSize());
        this.getStage().heightProperty().addListener((v, o, n) -> this.addStageSize());
        this.getStage().xProperty().addListener((v, o, n) -> this.addStageSize());
        this.getStage().yProperty().addListener((v, o, n) -> this.addStageSize());
    }

    private void addStageSize() {
        if (this.getStage().isShowing()) {
            P2GuiSize.getSize(ProgConfig.EPISODE_INFO_DIALOG_SHOW_BIG.get() ? ProgConfig.SYSTEM_SIZE_DIALOG_EPISODE_INFO : ProgConfig.SYSTEM_SIZE_DIALOG_EPISODE_INFO_SMALL, this.getStage());
        }
    }

    private void makePane() {
        GridPane gridPane = new GridPane();
        this.getVBoxCont().getChildren().clear();
        this.getVBoxCont().getChildren().add(gridPane);
        VBox.setVgrow(gridPane, Priority.ALWAYS);
        gridPane.setHgap(10.0);
        gridPane.setVgap(10.0);
        gridPane.setPadding(new Insets(5.0));
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        for (int i = 0; i < EpisodeFieldNames.MAX_ELEM; ++i) {
            this.textTitle[i] = new Text(EpisodeFieldNames.COLUMN_NAMES[i] + ":");
            this.lblCont[i] = new Label("");
            if (i == 9) {
                this.lblCont[i].setWrapText(true);
            } else {
                this.lblCont[i].setWrapText(false);
            }
            this.lblCont[i].maxWidthProperty().bind(this.getVBoxCompleteDialog().widthProperty().subtract(220));
        }
        this.makeGridPane(gridPane);
        this.setEpisode();
    }

    private void makeGridPane(GridPane gridPane) {
        int row = 0;
        block13: for (int i = 0; i < EpisodeFieldNames.MAX_ELEM; ++i) {
            switch (i) {
                case 0: {
                    if (!ProgConfig.EPISODE_INFO_DIALOG_SHOW_BIG.getValue().booleanValue()) continue block13;
                    gridPane.add(this.textTitle[0], 0, row);
                    gridPane.add(this.lblCont[0], 1, row++);
                    continue block13;
                }
                case 2: {
                    gridPane.add(this.textTitle[2], 0, row);
                    gridPane.add(this.lblCont[2], 1, row++);
                    continue block13;
                }
                case 3: {
                    gridPane.add(this.textTitle[3], 0, row);
                    gridPane.add(this.lblCont[3], 1, row++);
                    continue block13;
                }
                case 5: {
                    if (!ProgConfig.EPISODE_INFO_DIALOG_SHOW_BIG.getValue().booleanValue()) continue block13;
                    gridPane.add(this.textTitle[5], 0, row);
                    gridPane.add(this.lblCont[5], 1, row++);
                    continue block13;
                }
                case 8: {
                    gridPane.add(this.textTitle[8], 0, row);
                    gridPane.add(this.lblCont[8], 1, row++);
                    continue block13;
                }
                case 9: {
                    if (!ProgConfig.EPISODE_INFO_DIALOG_SHOW_BIG.getValue().booleanValue()) continue block13;
                    this.taDescription.setMinHeight(25.0);
                    GridPane.setVgrow(this.taDescription, Priority.ALWAYS);
                    this.taDescription.setEditable(false);
                    this.taDescription.setWrapText(true);
                    gridPane.add(this.textTitle[9], 0, row);
                    gridPane.add(this.taDescription, 1, row++);
                    continue block13;
                }
                case 10: {
                    if (!ProgConfig.EPISODE_INFO_DIALOG_SHOW_BIG.getValue().booleanValue()) continue block13;
                    gridPane.add(this.textTitle[10], 0, row);
                    gridPane.add(this.lblCont[10], 1, row++);
                    continue block13;
                }
                case 11: {
                    if (!ProgConfig.EPISODE_INFO_DIALOG_SHOW_BIG.getValue().booleanValue()) continue block13;
                    gridPane.add(this.textTitle[11], 0, row);
                    gridPane.add(this.lblCont[11], 1, row++);
                    continue block13;
                }
                case 13: {
                    if (!ProgConfig.EPISODE_INFO_DIALOG_SHOW_BIG.getValue().booleanValue()) continue block13;
                    gridPane.add(this.textTitle[13], 0, row);
                    gridPane.add(this.pHyperlinkUrl, 1, row++);
                    continue block13;
                }
                case 14: {
                    if (!ProgConfig.EPISODE_INFO_DIALOG_SHOW_BIG.getValue().booleanValue()) continue block13;
                    gridPane.add(this.textTitle[14], 0, row);
                    gridPane.add(this.pHyperlinkWebsite, 1, row++);
                    continue block13;
                }
                case 15: {
                    if (!ProgConfig.EPISODE_INFO_DIALOG_SHOW_BIG.getValue().booleanValue()) continue block13;
                    gridPane.add(this.textTitle[15], 0, row);
                    gridPane.add(this.lblCont[15], 1, row++);
                }
            }
        }
    }

    private void setEpisode() {
        block13: for (int i = 0; i < EpisodeFieldNames.MAX_ELEM; ++i) {
            if (this.episode == null) {
                this.lblCont[i].setText("");
                this.ivNew.setImage(null);
                this.taDescription.setText("");
                this.pHyperlinkUrl.setUrl("");
                this.pHyperlinkWebsite.setUrl("");
                continue;
            }
            switch (i) {
                case 0: {
                    this.lblCont[i].setText("" + this.episode.getNo());
                    continue block13;
                }
                case 2: {
                    this.lblCont[i].setText(this.episode.getEpisodeTitle());
                    continue block13;
                }
                case 3: {
                    Podcast podcast = this.progData.podcastList.getPodcastById(this.episode.getPodcastId());
                    if (podcast == null) continue block13;
                    this.lblCont[i].setText(podcast.getName());
                    continue block13;
                }
                case 5: {
                    this.lblCont[i].setText(this.episode.getGenre());
                    continue block13;
                }
                case 8: {
                    this.lblCont[i].setText(this.episode.getDurationStr());
                    continue block13;
                }
                case 9: {
                    this.taDescription.setText(this.episode.getDescription());
                    this.lblCont[i].setText(this.episode.getDescription());
                    continue block13;
                }
                case 10: {
                    this.lblCont[i].setText(this.episode.getFileName());
                    continue block13;
                }
                case 11: {
                    this.lblCont[i].setText(this.episode.getFilePath());
                    continue block13;
                }
                case 13: {
                    this.pHyperlinkUrl.setUrl(this.episode.getEpisodeUrl());
                    continue block13;
                }
                case 14: {
                    this.pHyperlinkWebsite.setUrl(this.episode.getEpisodeWebsite());
                    continue block13;
                }
                case 15: {
                    this.lblCont[i].setText(P2LDateFactory.toString(this.episode.getPubDate()));
                }
            }
        }
    }

    private void setBtnUpDownToolTip() {
        this.btnUpDown.setTooltip(ProgConfig.EPISODE_INFO_DIALOG_SHOW_BIG.getValue() != false ? new Tooltip("weniger Informationen zur Episode anzeigen") : new Tooltip("mehr Informationen zur Episode anzeigen"));
        this.btnUpDown.setGraphic(ProgConfig.EPISODE_INFO_DIALOG_SHOW_BIG.getValue() != false ? ProgIcons.ICON_BUTTON_UP.getImageView() : ProgIcons.ICON_BUTTON_DOWN.getImageView());
    }

    private void initUrl() {
        this.pHyperlinkUrl.setWrapText(true);
        this.pHyperlinkUrl.maxWidthProperty().bind(this.getVBoxCompleteDialog().widthProperty().subtract(220));
        this.pHyperlinkWebsite.setWrapText(true);
        this.pHyperlinkWebsite.maxWidthProperty().bind(this.getVBoxCompleteDialog().widthProperty().subtract(220));
    }
}

