/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.dialog;

import de.p2tools.p2lib.dialogs.P2DirFileChooser;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2podder.controller.ProgIcons;
import de.p2tools.p2podder.controller.config.ProgConfig;
import javafx.beans.property.StringProperty;
import javafx.geometry.Insets;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;

public class DownPathPane {
    private final TextField txtPath = new TextField();
    StringProperty pathProp = ProgConfig.START_DIALOG_DOWNLOAD_PATH;
    private final Stage stage;

    public DownPathPane(Stage stage) {
        this.stage = stage;
    }

    public void close() {
        this.txtPath.textProperty().unbindBidirectional(this.pathProp);
    }

    public TitledPane makePath() {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(15.0);
        gridPane.setVgap(15.0);
        gridPane.setPadding(new Insets(20.0));
        this.txtPath.textProperty().bindBidirectional(this.pathProp);
        Button btnFile = new Button();
        btnFile.setOnAction(event -> P2DirFileChooser.DirChooser(this.stage, this.txtPath));
        btnFile.setGraphic(ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView());
        btnFile.setTooltip(new Tooltip("Einen Pfad zum Speichern ausw\u00e4hlen"));
        Button btnHelp = P2Button.helpButton(this.stage, "Zielverzeichnis", "Hier kann das Verzeichnis angegeben werden, in dem die Downloads gespeichert werden.");
        int row = 0;
        gridPane.add(new Label("Pfad:"), 0, row);
        gridPane.add(this.txtPath, 1, row);
        gridPane.add(btnFile, 2, row);
        gridPane.add(btnHelp, 3, row);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        TitledPane tpConfig = new TitledPane("Pfad f\u00fcr die Downloads", gridPane);
        return tpConfig;
    }
}

