/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.configdialog.setdata;

import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.guitools.P2GuiTools;
import de.p2tools.p2podder.controller.ProgIcons;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.ImportSetDataFactory;
import de.p2tools.p2podder.controller.data.SetData;
import de.p2tools.p2podder.controller.data.SetFactory;
import de.p2tools.p2podder.gui.configdialog.setdata.ControllerSet;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class PaneSetList
extends TitledPane {
    static int newCounter = 1;
    private final ProgData progData;
    private final TableView<SetData> tableView = new TableView();
    private final ControllerSet controllerSet;

    public PaneSetList(ControllerSet controllerSet) {
        this.controllerSet = controllerSet;
        this.progData = ProgData.getInstance();
        this.make();
    }

    public void close() {
    }

    private void make() {
        VBox vBox = new VBox(5.0);
        this.initTable(vBox);
        this.setText("Sets");
        this.setContent(vBox);
        this.setCollapsible(false);
        this.setMaxHeight(Double.MAX_VALUE);
    }

    private void initTable(VBox vBox) {
        this.tableView.getSelectionModel().selectedItemProperty().addListener((observable2, oldValue, newValue) -> this.controllerSet.aktSetDateProperty().setValue((SetData)newValue));
        TableColumn nameColumn = new TableColumn("Name");
        nameColumn.setCellValueFactory(new PropertyValueFactory("name"));
        nameColumn.setCellFactory(TextFieldTableCell.forTableColumn());
        this.tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.tableView.getColumns().addAll(nameColumn);
        this.tableView.setItems(this.progData.setDataList);
        if (this.tableView.getItems().size() > 0) {
            this.tableView.getSelectionModel().select(0);
        }
        this.tableView.getSelectionModel().selectFirst();
        VBox.setVgrow(this.tableView, Priority.ALWAYS);
        vBox.getChildren().addAll((Node[])new Node[]{this.tableView});
        Button btnDel = new Button("");
        btnDel.setTooltip(new Tooltip("Markiertes Set l\u00f6schen"));
        btnDel.setGraphic(ProgIcons.ICON_BUTTON_REMOVE.getImageView());
        btnDel.setOnAction(event -> {
            SetData setData = this.getSelectedSelData();
            if (setData != null) {
                this.progData.setDataList.removeSetData(setData);
            }
        });
        Button btnNew = new Button("");
        btnNew.setTooltip(new Tooltip("Ein neues Set anlegen"));
        btnNew.setGraphic(ProgIcons.ICON_BUTTON_ADD.getImageView());
        btnNew.setOnAction(event -> {
            SetData setData = new SetData("Neu-" + ++newCounter);
            this.progData.setDataList.addSetData(setData);
        });
        Button btnUp = new Button("");
        btnUp.setTooltip(new Tooltip("Markiertes Set nach oben schieben"));
        btnUp.setGraphic(ProgIcons.ICON_BUTTON_MOVE_UP.getImageView());
        btnUp.setOnAction(event -> {
            int sel = this.getSelectedLine();
            if (sel >= 0) {
                int newSel = this.progData.setDataList.up(sel, true);
                this.tableView.getSelectionModel().select(newSel);
            }
        });
        Button btnDown = new Button("");
        btnDown.setTooltip(new Tooltip("Markiertes Set nach unten schieben"));
        btnDown.setGraphic(ProgIcons.ICON_BUTTON_MOVE_DOWN.getImageView());
        btnDown.setOnAction(event -> {
            int sel = this.getSelectedLine();
            if (sel >= 0) {
                int newSel = this.progData.setDataList.up(sel, false);
                this.tableView.getSelectionModel().select(newSel);
            }
        });
        Button btnStandard = new Button("Als _Standardset setzen");
        btnStandard.setTooltip(new Tooltip("Das Set als Standardset festlegen"));
        btnStandard.setOnAction(event -> {
            SetData setData = this.getSelectedSelData();
            if (setData != null) {
                this.progData.setDataList.removeSetData(setData);
                this.progData.setDataList.add(0, setData);
                this.tableView.getSelectionModel().select(0);
            }
        });
        HBox.setHgrow(btnStandard, Priority.ALWAYS);
        btnStandard.setMaxWidth(Double.MAX_VALUE);
        Button btnDup = new Button("_Duplizieren");
        btnDup.setTooltip(new Tooltip("Eine Kopie des markierten Sets erstellen"));
        btnDup.setOnAction(event -> {
            SetData setData = this.getSelectedSelData();
            if (setData != null) {
                this.progData.setDataList.addSetData(setData.copy());
            }
        });
        HBox.setHgrow(btnDup, Priority.ALWAYS);
        btnDup.setMaxWidth(Double.MAX_VALUE);
        Button btnNewSet = new Button("Standardsets _anf\u00fcgen");
        btnNewSet.setTooltip(new Tooltip("Standardsets erstellen und der Liste anf\u00fcgen"));
        btnNewSet.setOnAction(event -> {
            if (!SetFactory.addSetTemplate(ImportSetDataFactory.getStandarset())) {
                P2Alert.showErrorAlert("Set importieren", "Set konnten nicht importiert werden!");
            }
        });
        HBox.setHgrow(btnNewSet, Priority.ALWAYS);
        btnNewSet.setMaxWidth(Double.MAX_VALUE);
        Button btnCheck = new Button("_Pr\u00fcfen");
        btnCheck.setTooltip(new Tooltip("Die angelegten Sets \u00fcberpr\u00fcfen"));
        btnCheck.setOnAction(event -> SetFactory.checkPrograms(this.progData));
        HBox.setHgrow(btnCheck, Priority.ALWAYS);
        btnCheck.setMaxWidth(Double.MAX_VALUE);
        HBox hBox = new HBox(5.0);
        HBox.setHgrow(hBox, Priority.ALWAYS);
        hBox.setAlignment(Pos.CENTER_RIGHT);
        hBox.getChildren().addAll((Node[])new Node[]{btnNew, btnDel, P2GuiTools.getHBoxGrower(), btnUp, btnDown});
        vBox.getChildren().addAll((Node[])new Node[]{hBox, btnStandard, btnDup, btnNewSet, btnCheck});
    }

    private SetData getSelectedSelData() {
        SetData sel = (SetData)this.tableView.getSelectionModel().getSelectedItem();
        if (sel == null) {
            P2Alert.showInfoNoSelection();
        }
        return sel;
    }

    private int getSelectedLine() {
        int sel = this.tableView.getSelectionModel().getSelectedIndex();
        if (sel < 0) {
            P2Alert.showInfoNoSelection();
        }
        return sel;
    }
}

