/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.configdialog.setdata;

import de.p2tools.p2lib.dialogs.P2DirFileChooser;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2Styles;
import de.p2tools.p2podder.controller.ProgIcons;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.SetData;
import de.p2tools.p2podder.controller.data.SetFactory;
import de.p2tools.p2podder.gui.configdialog.setdata.ControllerSet;
import de.p2tools.p2podder.gui.tools.HelpText;
import java.io.File;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class PaneSetData
extends TitledPane {
    private final TextField txtVisibleName = new TextField("");
    private final TextArea txtDescription = new TextArea("");
    private final TextField txtProgPath = new TextField();
    private final TextField txtProgSwitch = new TextField();
    private final Button btnFile = new Button();
    private final Button btnFind = new Button("suchen");
    private final Button btnHelpSearch;
    private final Label lblName = new Label("Name:");
    private final Label lblDescription = new Label("Beschreibung:");
    private final Label lblProgram = new Label("Programm:");
    private final Label lblSwitch = new Label("Schalter:");
    private final Stage stage;
    private final ControllerSet controllerSet;
    private ChangeListener<SetData> changeListener;
    private SetData setData = null;

    PaneSetData(ControllerSet controllerSet) {
        this.controllerSet = controllerSet;
        this.stage = controllerSet.getStage();
        this.btnHelpSearch = P2Button.helpButton(this.stage, "Videoplayer", HelpText.PROG_PATHS);
        this.makePane();
    }

    public void close() {
        this.unBindProgData();
    }

    private void makePane() {
        this.changeListener = (observable2, oldValue, newValue) -> this.bindProgData((SetData)newValue);
        this.controllerSet.aktSetDateProperty().addListener(this.changeListener);
        this.bindProgData((SetData)this.controllerSet.aktSetDateProperty().getValue());
        VBox vBox = new VBox(5.0);
        vBox.setFillWidth(true);
        vBox.setPadding(new Insets(10.0));
        this.setText("Set Einstellungen");
        this.setContent(vBox);
        this.setCollapsible(false);
        this.setMaxHeight(Double.MAX_VALUE);
        this.btnFile.setOnAction(event -> P2DirFileChooser.FileChooserOpenFile(ProgData.getInstance().primaryStage, this.txtProgPath));
        this.btnFile.setGraphic(ProgIcons.ICON_BUTTON_FILE_OPEN.getImageView());
        this.btnFile.setTooltip(new Tooltip("Ein Programm zum verarbeiten der URL ausw\u00e4hlen"));
        this.btnFind.setOnAction(event -> this.txtProgPath.setText(SetFactory.getTemplatePathVlc()));
        this.txtProgPath.textProperty().addListener((observable2, oldValue, newValue) -> {
            File file = new File(this.txtProgPath.getText());
            if (!file.exists() || !file.isFile()) {
                this.txtProgPath.setStyle(P2Styles.PTEXTFIELD_ERROR);
            } else {
                this.txtProgPath.setStyle("");
            }
        });
        this.txtDescription.setWrapText(true);
        int row = 0;
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        gridPane.add(this.lblName, 0, row);
        gridPane.add(this.txtVisibleName, 1, row, 4, 1);
        gridPane.add(this.lblDescription, 0, ++row);
        gridPane.add(this.txtDescription, 1, row, 4, 1);
        gridPane.add(this.lblProgram, 0, ++row);
        gridPane.add(this.txtProgPath, 1, row);
        gridPane.add(this.btnFile, 2, row);
        gridPane.add(this.btnFind, 3, row);
        gridPane.add(this.btnHelpSearch, 4, row);
        gridPane.add(this.lblSwitch, 0, ++row);
        gridPane.add(this.txtProgSwitch, 1, row, 4, 1);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        vBox.getChildren().add(gridPane);
        Button btnHelp = P2Button.helpButton(this.stage, "Set", "Ein Set ist ein Hilfsprogramm (z.B. VLC), mit dem die Episoden abgespielt werden k\u00f6nnen.\n\nDas Standardset ist immer das erste in der Tabelle. Ist nur ein Set angelegt, ist es immer das Standardset. Das Standardset wird beim Abspielen einer Episode \u00fcber die Buttons zum Abspielen verwendet. Sind weitere Sets vorhanden, k\u00f6nnen \u00fcber das Men\u00fc damit Episoden gestartet werden. \n\n==================================================\n\nSet Einstellungen: \n\n\"Name\"\nHier kann ein Name f\u00fcr das Set angegeben werden. Er ist nur zur eigenen Info.\n\n\"Beschreibung\"\nHier k\u00f6nnen Infos zum Set angegeben werden die auch nur zur eigenen Info dienen.\n\n\"Programm\"\nIn dem Feld steht NUR!! das Programm: \"Pfad/Programmdatei\"\n\n\"Schalter\"\nIn diesem Feld werden die Programmschalter angegeben, die das Programm zum Start braucht. Der Parameter %f steht f\u00fcr den Pfad und Dateinamen der Episode und wird beim Start der Episode ersetzt.\n\n==================================================\n\nBeispiel f\u00fcr den VLC:\n\nProgramm (Linux):  \"/usr/bin/vlc\"\nProgramm (Windows):  \"C:\\Program Files\\VideoLAN\\VLC\\vlc.exe\"\n\nSchalter: \"%f --play-and-exit\n\nHier wird %f durch den Pfad zur Datei ersetzt. Der Programmaufruf sieht dann so aus:\n\n/usr/bin/vlc PFAD-DATEINAME --play-and-exit\n");
        HBox hBox = new HBox();
        VBox.setVgrow(hBox, Priority.ALWAYS);
        hBox.setAlignment(Pos.BOTTOM_RIGHT);
        hBox.getChildren().add(btnHelp);
        vBox.getChildren().add(hBox);
    }

    private void bindProgData(SetData setData) {
        this.unBindProgData();
        this.setData = setData;
        if (setData != null) {
            this.txtVisibleName.textProperty().bindBidirectional(setData.nameProperty());
            this.txtProgPath.textProperty().bindBidirectional(setData.progPathProperty());
            this.txtProgSwitch.textProperty().bindBidirectional(setData.progSwitchProperty());
            this.txtDescription.textProperty().bindBidirectional(setData.descriptionProperty());
            this.setDis(false);
        } else {
            this.txtVisibleName.setText("");
            this.txtProgPath.setText("");
            this.txtProgSwitch.setText("");
            this.txtDescription.setText("");
            this.setDis(true);
        }
    }

    private void setDis(boolean set) {
        this.txtVisibleName.setDisable(set);
        this.txtProgPath.setDisable(set);
        this.txtProgSwitch.setDisable(set);
        this.txtDescription.setDisable(set);
        this.btnFile.setDisable(set);
        this.btnFind.setDisable(set);
        this.btnHelpSearch.setDisable(set);
        this.lblName.setDisable(set);
        this.lblDescription.setDisable(set);
        this.lblProgram.setDisable(set);
        this.lblSwitch.setDisable(set);
    }

    private void unBindProgData() {
        if (this.setData != null) {
            this.txtVisibleName.textProperty().unbindBidirectional(this.setData.nameProperty());
            this.txtProgPath.textProperty().unbindBidirectional(this.setData.progPathProperty());
            this.txtProgSwitch.textProperty().unbindBidirectional(this.setData.progSwitchProperty());
            this.txtDescription.textProperty().unbindBidirectional(this.setData.descriptionProperty());
        }
    }
}

