/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.configdialog;

import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.download.DownloadFactory;
import java.util.Collection;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;

public class PaneEpisode {
    private final ProgData progData;
    private P2ToggleSwitch tglDelFile = new P2ToggleSwitch("");
    private CheckBox chkAsk = new CheckBox("Vorher immer fragen");
    private final Stage stage;

    public PaneEpisode(Stage stage) {
        this.stage = stage;
        this.progData = ProgData.getInstance();
    }

    public void close() {
        this.tglDelFile.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_DELETE_EPISODE_FILE);
        this.chkAsk.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_DELETE_EPISODE_FILE_ASK);
    }

    public void makePane(Collection<TitledPane> result) {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        gridPane.setPadding(new Insets(10.0));
        TitledPane tpConfig = new TitledPane("Speicherordner", gridPane);
        result.add(tpConfig);
        this.tglDelFile.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_DELETE_EPISODE_FILE);
        this.chkAsk.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_DELETE_EPISODE_FILE_ASK);
        this.chkAsk.disableProperty().bind(ProgConfig.SYSTEM_DELETE_EPISODE_FILE.not());
        Button btnCleanHelp = P2Button.helpButton(this.stage, "Speicherordner aufr\u00e4umen", "Im Ordner (Speicherort der Episoden der Podcasts) werden alle Dateien gel\u00f6scht, f\u00fcr die es keine Episode gibt.\n");
        Button btnClean = new Button("Aufr\u00e4umen");
        btnClean.setTooltip(new Tooltip("Dateien ohne entsprechende Episode l\u00f6schen."));
        btnClean.setOnAction(a -> DownloadFactory.cleanUpDownloadDir());
        int row = 0;
        gridPane.add(new Label("Beim L\u00f6schen von Episoden auch die zugeh\u00f6rige Datei l\u00f6schen"), 0, row, 2, 1);
        gridPane.add(this.tglDelFile, 2, row, 2, 1);
        gridPane.add(this.chkAsk, 1, ++row);
        GridPane.setHalignment(this.tglDelFile, HPos.RIGHT);
        ++row;
        gridPane.add(new Label("Downloadordner jetzt aufr\u00e4umen"), 0, ++row, 2, 1);
        gridPane.add(btnClean, 2, row);
        gridPane.add(btnCleanHelp, 3, row);
        GridPane.setHalignment(btnClean, HPos.RIGHT);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcPrefSize()});
    }
}

