/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.configdialog;

import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.ptoggleswitch.P2ToggleSwitch;
import de.p2tools.p2lib.tools.P2StringUtils;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.gui.tools.HelpText;
import java.util.Collection;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;

public class PaneConfig {
    private final ProgData progData;
    private final P2ToggleSwitch tglSmallButton = new P2ToggleSwitch("In den Tabellen nur kleine Buttons anzeigen");
    private TextField txtUserAgent;
    private final Stage stage;

    public PaneConfig(Stage stage) {
        this.stage = stage;
        this.progData = ProgData.getInstance();
    }

    public void close() {
        this.tglSmallButton.selectedProperty().unbindBidirectional(ProgConfig.SYSTEM_SMALL_BUTTON_TABLE_ROW);
        this.txtUserAgent.textProperty().unbindBidirectional(ProgConfig.SYSTEM_USERAGENT);
    }

    public void makeConfig(Collection<TitledPane> result) {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        gridPane.setPadding(new Insets(10.0));
        TitledPane tpConfig = new TitledPane("Allgemein", gridPane);
        result.add(tpConfig);
        this.tglSmallButton.selectedProperty().bindBidirectional(ProgConfig.SYSTEM_SMALL_BUTTON_TABLE_ROW);
        Button btnHelpSize = P2Button.helpButton(this.stage, "Nur kleine Button anzeigen", "In den Tabellen (Episoden, Podcasts und Downloads) k\u00f6nnen auch kleine Buttons angezeigt werden. Die Zeilenh\u00f6he wird dadurch kleiner.\n");
        GridPane.setHalignment(btnHelpSize, HPos.RIGHT);
        Button btnHelpUserAgent = P2Button.helpButton(this.stage, "User Agent festlegen", HelpText.USER_AGENT);
        GridPane.setHalignment(btnHelpUserAgent, HPos.RIGHT);
        this.txtUserAgent = new TextField(){

            @Override
            public void replaceText(int start, int end, String text) {
                if (this.check(text)) {
                    super.replaceText(start, end, text);
                }
            }

            @Override
            public void replaceSelection(String text) {
                if (this.check(text)) {
                    super.replaceSelection(text);
                }
            }

            private boolean check(String text) {
                String str = P2StringUtils.convertToASCIIEncoding(text);
                int size = this.getText().length() + text.length();
                return text.isEmpty() || size < 100 && text.equals(str);
            }
        };
        this.txtUserAgent.textProperty().bindBidirectional(ProgConfig.SYSTEM_USERAGENT);
        int row = 0;
        gridPane.add(this.tglSmallButton, 0, row, 2, 1);
        gridPane.add(btnHelpSize, 2, row);
        gridPane.add(new Label(), 0, ++row);
        gridPane.add(new Label("User Agent:"), 0, ++row);
        gridPane.add(this.txtUserAgent, 1, row);
        gridPane.add(btnHelpUserAgent, 2, row);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize()});
    }
}

