/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui.configdialog;

import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.p2event.P2Event;
import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2podder.controller.config.PEvents;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.gui.configdialog.ControllerConfig;
import de.p2tools.p2podder.gui.configdialog.ControllerEpisode;
import de.p2tools.p2podder.gui.configdialog.ControllerPodcast;
import de.p2tools.p2podder.gui.configdialog.setdata.ControllerSet;
import javafx.geometry.Insets;
import javafx.scene.control.Button;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class ConfigDialogController
extends P2DialogExtra {
    private final TabPane tabPane = new TabPane();
    private final Button btnOk = new Button("_Ok");
    private ControllerConfig controllerConfig;
    private ControllerEpisode controllerEpisode;
    private ControllerPodcast controllerPodcast;
    private ControllerSet controllerSet;

    public ConfigDialogController(ProgData progData) {
        super(progData.primaryStage, ProgConfig.CONFIG_DIALOG_SIZE, "Einstellungen", true, false, P2DialogExtra.DECO.NO_BORDER);
        this.init(true);
    }

    @Override
    public void make() {
        VBox.setVgrow(this.tabPane, Priority.ALWAYS);
        this.getVBoxCont().getChildren().add(this.tabPane);
        this.getVBoxCont().setPadding(new Insets(0.0));
        this.addOkButton(this.btnOk);
        this.btnOk.setOnAction(a -> this.close());
        ProgConfig.SYSTEM_THEME_CHANGED.addListener((u, o, n) -> this.updateCss());
        this.initPanel();
    }

    @Override
    public void close() {
        this.controllerConfig.close();
        this.controllerEpisode.close();
        this.controllerPodcast.close();
        this.controllerSet.close();
        ProgData.getInstance().pEventHandler.notifyListener(new P2Event(PEvents.EVENT_SETDATA_CHANGED));
        super.close();
    }

    private void initPanel() {
        try {
            this.controllerConfig = new ControllerConfig(this.getStage());
            Tab tab = new Tab("Allgemein");
            tab.setClosable(false);
            tab.setContent(this.controllerConfig);
            this.tabPane.getTabs().add(tab);
            this.controllerEpisode = new ControllerEpisode(this.getStage());
            tab = new Tab("Episoden");
            tab.setClosable(false);
            tab.setContent(this.controllerEpisode);
            this.tabPane.getTabs().add(tab);
            this.controllerPodcast = new ControllerPodcast(this.getStage());
            tab = new Tab("Podcast");
            tab.setClosable(false);
            tab.setContent(this.controllerPodcast);
            this.tabPane.getTabs().add(tab);
            this.controllerSet = new ControllerSet(this.getStage());
            tab = new Tab("Abspielen");
            tab.setClosable(false);
            tab.setContent(this.controllerSet);
            this.tabPane.getTabs().add(tab);
            this.tabPane.getSelectionModel().select(ProgConfig.SYSTEM_CONFIG_DIALOG_TAB.get());
            this.tabPane.getSelectionModel().selectedIndexProperty().addListener((observable2, oldValue, newValue) -> ProgConfig.SYSTEM_CONFIG_DIALOG_TAB.setValue((Number)newValue));
        }
        catch (Exception ex) {
            P2Log.errorLog(784459510, ex);
        }
    }
}

