/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui;

import de.p2tools.p2lib.guitools.pclosepane.P2ClosePaneController;
import de.p2tools.p2lib.guitools.pclosepane.P2ClosePaneDto;
import de.p2tools.p2lib.guitools.pclosepane.P2ClosePaneFactory;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.gui.MenuController;
import de.p2tools.p2podder.gui.PodcastGuiController;
import de.p2tools.p2podder.gui.filter.PodcastFilterController;
import java.util.ArrayList;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.Node;
import javafx.scene.control.SplitPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;

public class PodcastGui {
    ProgData progData;
    private final SplitPane splitPane = new SplitPane();
    private final HBox hBox = new HBox();
    private final PodcastGuiController podcastGuiController;
    private final P2ClosePaneController infoController;
    private BooleanProperty bound = new SimpleBooleanProperty(false);

    public PodcastGui() {
        this.progData = ProgData.getInstance();
        this.progData.podcastGui = this;
        ArrayList<P2ClosePaneDto> list = new ArrayList<P2ClosePaneDto>();
        P2ClosePaneDto infoDto = new P2ClosePaneDto(new PodcastFilterController(), ProgConfig.PODCAST__FILTER_IS_RIP, ProgConfig.PODCAST__FILTER_DIALOG_SIZE, ProgData.PODCAST_TAB_ON, "Filter", "Podcast", true);
        list.add(infoDto);
        this.infoController = new P2ClosePaneController(list, ProgConfig.PODCAST__FILTER_IS_SHOWING);
        this.podcastGuiController = new PodcastGuiController();
    }

    public Pane pack() {
        MenuController menuController = new MenuController(MenuController.StartupMode.PODCAST);
        menuController.setId("station-menu-pane");
        this.splitPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        SplitPane.setResizableWithParent(this.infoController, Boolean.FALSE);
        this.hBox.setPrefSize(-1.0, -1.0);
        this.hBox.setMinSize(-1.0, -1.0);
        this.hBox.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        HBox.setHgrow(this.splitPane, Priority.ALWAYS);
        this.hBox.getChildren().addAll((Node[])new Node[]{this.splitPane, menuController});
        ProgConfig.PODCAST__FILTER_IS_SHOWING.addListener((observable2, oldValue, newValue) -> this.setSplit());
        this.setSplit();
        return this.hBox;
    }

    public PodcastGuiController getPodcastGuiController() {
        return this.podcastGuiController;
    }

    private void setSplit() {
        P2ClosePaneFactory.setSplit(this.bound, this.splitPane, this.infoController, true, this.podcastGuiController, ProgConfig.PODCAST__FILTER_DIVIDER, ProgConfig.PODCAST__FILTER_IS_SHOWING);
    }
}

