/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui;

import de.p2tools.p2lib.tools.shortcut.P2ShortcutWorker;
import de.p2tools.p2podder.controller.ProgIcons;
import de.p2tools.p2podder.controller.config.PShortCut;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.SetData;
import de.p2tools.p2podder.controller.data.episode.EpisodeFactory;
import de.p2tools.p2podder.gui.ToolBarButton;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.VBox;

public class EpisodeMenu {
    private final VBox vBox;
    private final ProgData progData;

    public EpisodeMenu(VBox vBox) {
        this.vBox = vBox;
        this.progData = ProgData.getInstance();
    }

    public void init() {
        this.vBox.getChildren().clear();
        this.initMenu();
        this.initButton();
    }

    private void initButton() {
        VBox vBoxSpace = new VBox();
        vBoxSpace.setMaxHeight(0.0);
        vBoxSpace.setMinHeight(0.0);
        this.vBox.getChildren().add(vBoxSpace);
        ToolBarButton btStart = new ToolBarButton(this.vBox, "Markierte Episoden abspielen", "Markierte Episoden abspielen", ProgIcons.ICON_TOOLBAR_START.getImageView());
        ToolBarButton btPlayNext = new ToolBarButton(this.vBox, "N\u00e4chste gestartete Episoden abspielen", "N\u00e4chste gestartete Episoden abspielen", ProgIcons.ICON_TOOLBAR_PLAY_NEXT.getImageView());
        ToolBarButton btStop = new ToolBarButton(this.vBox, "Alle laufenden Episoden stoppen", "Alle laufenden Episoden stoppen", ProgIcons.ICON_TOOLBAR_STOP.getImageView());
        ToolBarButton btDel = new ToolBarButton(this.vBox, "Markierte Episoden l\u00f6schen", "Markierte Episoden l\u00f6schen", ProgIcons.ICON_TOOLBAR_DEL.getImageView());
        ToolBarButton btInfo = new ToolBarButton(this.vBox, "Info-Dialog anzeigen", "Info-Dialog anzeigen", ProgIcons.ICON_TOOLBAR_INFO.getImageView());
        btStart.setOnAction(a -> EpisodeFactory.playSelEpisode());
        btPlayNext.setOnAction(a -> EpisodeFactory.playNextEpisode());
        btStop.setOnAction(a -> EpisodeFactory.stopAllEpisode());
        btDel.setOnAction(a -> EpisodeFactory.delSelEpisode());
        btInfo.setOnAction(a -> this.progData.episodeInfoDialogController.toggleShowInfo());
    }

    private void initMenu() {
        boolean moreSets;
        MenuButton mb = new MenuButton("");
        mb.setTooltip(new Tooltip("Episoden-Men\u00fc anzeigen"));
        mb.setGraphic(ProgIcons.ICON_TOOLBAR_MENU.getImageView());
        mb.getStyleClass().addAll((String[])new String[]{"btnFunction", "btnFunc-0"});
        boolean bl = moreSets = this.progData.setDataList.size() > 1;
        if (moreSets) {
            Menu miStartWithSet = new Menu("Episode abspielen, Programm ausw\u00e4hlen");
            for (SetData set : this.progData.setDataList) {
                MenuItem miStart = new MenuItem(set.getName());
                miStart.setOnAction(a -> EpisodeFactory.playEpisode(set));
                miStartWithSet.getItems().add(miStart);
            }
            mb.getItems().addAll((MenuItem[])new MenuItem[]{miStartWithSet});
        } else {
            MenuItem miStart = new MenuItem("Episode abspielen");
            miStart.setOnAction(a -> EpisodeFactory.playEpisode());
            P2ShortcutWorker.addShortCut(miStart, PShortCut.SHORTCUT_EPOSODE_START);
            mb.getItems().addAll((MenuItem[])new MenuItem[]{miStart});
        }
        MenuItem miEpisodePlayNext = new MenuItem("N\u00e4chste Episode abspielen");
        miEpisodePlayNext.setOnAction(a -> EpisodeFactory.playNextEpisode());
        MenuItem miEpisodeStop = new MenuItem("Episode stoppen");
        miEpisodeStop.setOnAction(a -> EpisodeFactory.stopEpisode());
        MenuItem miStopAll = new MenuItem("Alle laufenden Episoden stoppen");
        miStopAll.setOnAction(a -> EpisodeFactory.stopAllEpisode());
        P2ShortcutWorker.addShortCut(miStopAll, PShortCut.SHORTCUT_EPISODE_STOP);
        MenuItem miEpisodeDel = new MenuItem("Episode l\u00f6schen");
        miEpisodeDel.setOnAction(a -> EpisodeFactory.delEpisode());
        MenuItem miDelShown = new MenuItem("Alle gespielten Episoden l\u00f6schen");
        miDelShown.setOnAction(a -> EpisodeFactory.delAllShownEpisodes());
        MenuItem miCopyUrl = new MenuItem("Episoden-URL kopieren");
        miCopyUrl.setOnAction(a -> EpisodeFactory.copyUrl());
        mb.getItems().addAll((MenuItem[])new MenuItem[]{miEpisodePlayNext, miEpisodeStop, miStopAll, miEpisodeDel, miDelShown, new SeparatorMenuItem(), miCopyUrl});
        mb.getItems().add(new SeparatorMenuItem());
        CheckMenuItem miShowFilter = new CheckMenuItem("Filter anzeigen");
        miShowFilter.disableProperty().bind(ProgConfig.EPISODE__FILTER_IS_RIP);
        miShowFilter.selectedProperty().bindBidirectional(ProgConfig.EPISODE__FILTER_IS_SHOWING);
        CheckMenuItem miShowInfo = new CheckMenuItem("Infos anzeigen");
        miShowInfo.disableProperty().bind(ProgConfig.EPISODE__PANE_INFO_IS_RIP);
        miShowInfo.selectedProperty().bindBidirectional(ProgConfig.EPISODE__INFO_IS_SHOWING);
        mb.getItems().addAll((MenuItem[])new MenuItem[]{miShowFilter, miShowInfo});
        this.vBox.getChildren().add(mb);
    }
}

