/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.gui;

import de.p2tools.p2lib.guitools.pclosepane.P2ClosePaneController;
import de.p2tools.p2lib.guitools.pclosepane.P2ClosePaneDto;
import de.p2tools.p2lib.guitools.pclosepane.P2ClosePaneFactory;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.gui.DownloadGuiController;
import de.p2tools.p2podder.gui.MenuController;
import de.p2tools.p2podder.gui.filter.DownloadFilterController;
import java.util.ArrayList;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.Node;
import javafx.scene.control.SplitPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;

public class DownloadGui {
    private ProgData progData;
    private final SplitPane splitPane = new SplitPane();
    private final HBox hBox = new HBox();
    private final DownloadGuiController downloadGuiController;
    private final P2ClosePaneController infoController;
    private BooleanProperty bound = new SimpleBooleanProperty(false);

    public DownloadGui() {
        this.progData = ProgData.getInstance();
        this.progData.downloadGui = this;
        ArrayList<P2ClosePaneDto> list = new ArrayList<P2ClosePaneDto>();
        P2ClosePaneDto infoDto = new P2ClosePaneDto(new DownloadFilterController(), ProgConfig.DOWNLOAD__FILTER_IS_RIP, ProgConfig.DOWNLOAD__FILTER_DIALOG_SIZE, ProgData.DOWNLOAD_TAB_ON, "Filter", "Download", true);
        list.add(infoDto);
        this.infoController = new P2ClosePaneController(list, ProgConfig.DOWNLOAD__FILTER_IS_SHOWING);
        this.downloadGuiController = new DownloadGuiController();
    }

    public DownloadGuiController getDownloadGuiController() {
        return this.downloadGuiController;
    }

    public Pane pack() {
        MenuController menuController = new MenuController(MenuController.StartupMode.DOWNLOAD);
        menuController.setId("download-menu-pane");
        this.splitPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        SplitPane.setResizableWithParent(this.infoController, Boolean.FALSE);
        this.hBox.setPrefSize(-1.0, -1.0);
        this.hBox.setMinSize(-1.0, -1.0);
        this.hBox.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        HBox.setHgrow(this.splitPane, Priority.ALWAYS);
        this.hBox.getChildren().addAll((Node[])new Node[]{this.splitPane, menuController});
        ProgConfig.DOWNLOAD__FILTER_IS_SHOWING.addListener((observable2, oldValue, newValue) -> this.setSplit());
        this.setSplit();
        return this.hBox;
    }

    private void setSplit() {
        P2ClosePaneFactory.setSplit(this.bound, this.splitPane, this.infoController, true, this.downloadGuiController, ProgConfig.DOWNLOAD__FILTER_DIVIDER, ProgConfig.DOWNLOAD__FILTER_IS_SHOWING);
    }
}

