/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.controller.worker;

import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.download.DownloadListFactory;
import java.text.NumberFormat;
import java.util.Locale;

public class InfoFactory {
    private static final String SEPARATOR = "   |   ";
    private static final NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.GERMANY);
    private static final ProgData progData = ProgData.getInstance();

    private InfoFactory() {
    }

    public static String getInfosEpisode() {
        int sumEpisodeList = InfoFactory.progData.episodeList.size();
        int sumEpisodesShown = InfoFactory.progData.episodeGui.getEpisodeGuiController().getEpisodesShown();
        String sumEpisodeListStr = numberFormat.format(sumEpisodeList);
        String sumEpisodeShownStr = numberFormat.format(sumEpisodesShown);
        Object textLinks = sumEpisodesShown == 1 ? "1 Episode" : sumEpisodeShownStr + " Episoden";
        if (sumEpisodeList != sumEpisodesShown) {
            textLinks = (String)textLinks + " (Insgesamt: " + sumEpisodeListStr + ")";
        }
        if (InfoFactory.progData.episodeInfos.getAmount() > 0) {
            textLinks = (String)textLinks + InfoFactory.getEpisodeRunningInfos();
        }
        return textLinks;
    }

    public static synchronized String getInfosPodcasts() {
        int sumPodcastsList = InfoFactory.progData.podcastList.size();
        int sumPodcastsShown = InfoFactory.progData.podcastGui.getPodcastGuiController().getPodcastShown();
        String sumPodcastListStr = numberFormat.format(sumPodcastsList);
        String sumPodcastShownStr = numberFormat.format(sumPodcastsShown);
        Object textLinks = sumPodcastsShown == 1 ? "1 Podcast" : sumPodcastShownStr + " Podcasts";
        if (sumPodcastsList != sumPodcastsShown) {
            textLinks = (String)textLinks + " (Insgesamt: " + sumPodcastListStr + " )";
        }
        textLinks = (String)textLinks + InfoFactory.addEpisodeInfos();
        return textLinks;
    }

    public static String getInfosDownloads() {
        int sumDownloadsList = InfoFactory.progData.downloadList.size();
        int sumDownloadsShown = InfoFactory.progData.downloadGui.getDownloadGuiController().getDownloadsShown();
        long running = DownloadListFactory.countRunningDownloads();
        String sumDownloadListStr = numberFormat.format(sumDownloadsList);
        String sumDownloadShownStr = numberFormat.format(sumDownloadsShown);
        Object textLinks = sumDownloadsShown == 1 ? "1 Download" : sumDownloadShownStr + " Downloads";
        if (sumDownloadsList != sumDownloadsShown) {
            textLinks = (String)textLinks + " (Insgesamt: " + sumDownloadListStr + " )";
        }
        if (running == 1L) {
            textLinks = (String)textLinks + SEPARATOR;
            textLinks = (String)textLinks + running + " gestarteter Download";
        } else if (running > 1L) {
            textLinks = (String)textLinks + SEPARATOR;
            textLinks = (String)textLinks + running + " gestartete Downloads";
        }
        textLinks = (String)textLinks + InfoFactory.addEpisodeInfos();
        return textLinks;
    }

    private static String addEpisodeInfos() {
        Object txt = "";
        if (InfoFactory.progData.episodeInfos.getAmount() > 0) {
            txt = (String)txt + SEPARATOR;
            txt = InfoFactory.progData.episodeInfos.getAmount() == 1 ? (String)txt + "1 Episode" : (String)txt + InfoFactory.progData.episodeInfos.getAmount() + " Episoden";
            txt = (String)txt + InfoFactory.getEpisodeRunningInfos();
        }
        return txt;
    }

    private static synchronized String getEpisodeRunningInfos() {
        Object textLinks = SEPARATOR;
        int running = 0;
        running = InfoFactory.progData.episodeInfos.getStarted();
        textLinks = running == 0 ? "" : (running == 1 ? (String)textLinks + "1 Episode gestartet" : (String)textLinks + running + " Episoden gestartet");
        return textLinks;
    }
}

