/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.controller.starterepisode;

import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2podder.controller.ProgIcons;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.starterepisode.Start;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.image.ImageView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Duration;

public class StartEpisodeErrorDialogController
extends P2DialogExtra {
    private final HBox hBoxTitle;
    private final VBox vBoxCont;
    private Label lblHeader = new Label("Fehler");
    private Button btnOk = new Button("_Ok");
    private Label lblEpisodeTitle = new Label("ARD: Tatort, ..");
    private Label lblUrl = new Label();
    private TextArea txtCont = new TextArea();
    private Label lblTime = new Label("");
    private ImageView imageView = new ImageView();
    private GridPane gridPane = new GridPane();
    private Timeline timeline = null;
    private Integer timeSeconds = ProgConfig.SYSTEM_PARAMETER_START_STATION_ERRORMSG_IN_SECOND.get();
    private final String message;
    private final Start start;

    public StartEpisodeErrorDialogController(Start start, String message) {
        super(ProgData.getInstance().primaryStage, ProgConfig.START_STATION_ERROR_DIALOG_SIZE, "Fehler", true, false);
        this.start = start;
        this.message = message;
        this.hBoxTitle = this.getHBoxTitle();
        this.vBoxCont = this.getVBoxCont();
        this.init(true);
    }

    @Override
    public void make() {
        this.initCont();
        this.lblEpisodeTitle.setStyle("-fx-font-weight: bold;");
        this.lblEpisodeTitle.setText(this.start.getEpisodeTitle());
        this.lblUrl.setText(this.start.getFilePathName());
        this.txtCont.setEditable(false);
        this.txtCont.setText(this.message);
        this.btnOk.setOnAction(event -> {
            this.stopCounter();
            this.quit();
        });
        this.imageView.setImage(ProgIcons.IMAGE_ATTENTION_64.getImage());
        this.lblTime.setText("");
        this.timeline = new Timeline();
        this.timeline.setCycleCount(-1);
        this.timeline.getKeyFrames().add(new KeyFrame(Duration.seconds(1.0), new CountdownAction(), new KeyValue[0]));
        this.timeline.playFromStart();
    }

    private void initCont() {
        this.hBoxTitle.getChildren().add(this.lblHeader);
        VBox vBox = new VBox();
        vBox.setPadding(new Insets(20.0));
        vBox.getChildren().add(this.imageView);
        this.gridPane.setMaxWidth(Double.MAX_VALUE);
        this.gridPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        this.gridPane.setHgap(10.0);
        this.gridPane.setVgap(10.0);
        int row = 0;
        this.gridPane.add(new Label("Episode:"), 0, row);
        this.gridPane.add(this.lblEpisodeTitle, 1, row);
        this.gridPane.add(new Label("URL:"), 0, ++row);
        this.gridPane.add(this.lblUrl, 1, row);
        GridPane.setHgrow(this.txtCont, Priority.ALWAYS);
        GridPane.setVgrow(this.txtCont, Priority.ALWAYS);
        this.gridPane.add(new Label("Fehler:"), 0, ++row);
        this.gridPane.add(this.txtCont, 1, row);
        this.gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        HBox hBox = new HBox(10.0);
        VBox.setVgrow(hBox, Priority.ALWAYS);
        hBox.getChildren().addAll((Node[])new Node[]{vBox, this.gridPane});
        this.vBoxCont.setPadding(new Insets(5.0));
        this.vBoxCont.setSpacing(10.0);
        this.vBoxCont.getChildren().add(hBox);
        this.addOkButton(this.btnOk);
        this.getHboxLeft().getChildren().add(this.lblTime);
    }

    private void stopCounter() {
        if (this.timeline != null) {
            this.timeline.stop();
        }
    }

    private void quit() {
        this.close();
    }

    private class CountdownAction
    implements EventHandler {
        private CountdownAction() {
        }

        public void handle(Event event) {
            Integer n = StartEpisodeErrorDialogController.this.timeSeconds;
            StartEpisodeErrorDialogController.this.timeSeconds = StartEpisodeErrorDialogController.this.timeSeconds - 1;
            if (StartEpisodeErrorDialogController.this.timeSeconds > 0) {
                StartEpisodeErrorDialogController.this.lblTime.setText("" + StartEpisodeErrorDialogController.this.timeSeconds);
            } else {
                StartEpisodeErrorDialogController.this.stopCounter();
                StartEpisodeErrorDialogController.this.quit();
            }
        }
    }
}

