/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.controller.starterepisode;

import de.p2tools.p2lib.configfile.config.Config;
import de.p2tools.p2lib.tools.date.P2Date;
import de.p2tools.p2lib.tools.file.P2FileUtils;
import de.p2tools.p2podder.controller.data.SetData;
import de.p2tools.p2podder.controller.data.episode.Episode;
import de.p2tools.p2podder.controller.starterepisode.EpisodeStarterFactory;
import de.p2tools.p2podder.controller.starterepisode.StartProgramFactory;
import de.p2tools.p2podder.controller.starterepisode.StartProps;
import de.p2tools.p2podder.controller.starterepisode.StartStatus;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public final class Start
extends StartProps {
    private final StartStatus startStatus = new StartStatus();
    private Episode episode = null;
    private int startCounter = 0;
    private int restartCounter = 0;
    private final StringProperty programCall = new SimpleStringProperty("");
    private final StringProperty programCallArray = new SimpleStringProperty("");
    private Process process = null;
    private P2Date startTime = new P2Date();
    private SetData setData = null;
    private EpisodeStarterFactory episodeStarterFactory = null;

    public Start() {
    }

    public Start(SetData setData, Episode episode) {
        this.episode = episode;
        this.setData = setData;
        this.setEpisodeTitle(episode.getEpisodeTitle());
        String pathName = P2FileUtils.addsPath(episode.getFilePath(), episode.getFileName());
        this.setFilePathName(pathName);
        StartProgramFactory.makeProgParameter(this);
    }

    public P2Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(P2Date startTime) {
        this.startTime = startTime;
    }

    public int getStartCounter() {
        return this.startCounter;
    }

    public void incStartCounter() {
        ++this.startCounter;
    }

    public int getRestartCounter() {
        return this.restartCounter;
    }

    public Process getProcess() {
        return this.process;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    @Override
    public String getProgramCall() {
        return (String)this.programCall.get();
    }

    @Override
    public StringProperty programCallProperty() {
        return this.programCall;
    }

    @Override
    public void setProgramCall(String programCall) {
        this.programCall.set(programCall);
    }

    @Override
    public String getProgramCallArray() {
        return (String)this.programCallArray.get();
    }

    @Override
    public StringProperty programCallArrayProperty() {
        return this.programCallArray;
    }

    @Override
    public void setProgramCallArray(String programCallArray) {
        this.programCallArray.set(programCallArray);
    }

    public StartStatus getStartStatus() {
        return this.startStatus;
    }

    public Episode getEpisode() {
        return this.episode;
    }

    public SetData getSetData() {
        return this.setData;
    }

    public Start getCopy() {
        Start ret = new Start();
        ret.setData = this.setData;
        Config[] configs = this.getConfigsArr();
        Config[] configsCopy = ret.getConfigsArr();
        for (int i = 0; i < configs.length; ++i) {
            configsCopy[i].setActValue(configs[i].getActValueString());
        }
        return ret;
    }

    public void copyToMe(Start start) {
        this.setData = start.setData;
        Config[] configs = start.getConfigsArr();
        Config[] configsCopy = this.getConfigsArr();
        for (int i = 0; i < configs.length; ++i) {
            configsCopy[i].setActValue(configs[i].getActValueString());
        }
    }
}

