/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.controller.parser;

import de.p2tools.p2lib.p2event.P2Event;
import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2podder.controller.ProgQuitFactory;
import de.p2tools.p2podder.controller.config.PEvents;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.download.DownloadFactory;
import de.p2tools.p2podder.controller.data.podcast.Podcast;
import de.p2tools.p2podder.controller.parser.ParseRss;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

public class ParserThread {
    private final ProgData progData;
    private Parser parser = new Parser();
    private boolean andStartDownload = false;

    public ParserThread(ProgData progData) {
        this.progData = progData;
        ProgConfig.META_PODCAST_LIST_DATE.setValue(LocalDateTime.now());
    }

    public void parse(Podcast podcast) {
        this.parser.addPodcast(podcast);
        new Thread(this.parser).start();
    }

    public void parse(List<Podcast> podcastList) {
        this.parse(podcastList, false);
    }

    public void parse(List<Podcast> podcastList, boolean andStartDownload) {
        this.andStartDownload = andStartDownload;
        podcastList.forEach(p -> {
            if (p.isActive()) {
                this.parser.addPodcast((Podcast)p);
            }
        });
        new Thread(this.parser).start();
    }

    public void stopParser() {
        if (this.parser != null) {
            this.parser.stopParser();
        }
    }

    private class Parser
    implements Runnable {
        private List<Podcast> podcastList = new ArrayList<Podcast>();
        private boolean stop = false;

        void addPodcast(Podcast podcast) {
            this.podcastList.add(podcast);
        }

        void addPodcast(List<Podcast> podcastList) {
            this.podcastList.addAll(podcastList);
        }

        @Override
        public void run() {
            try {
                int count = 0;
                for (Podcast podcast : this.podcastList) {
                    if (this.stop) break;
                    P2Log.sysLog("Parse Podcast: " + podcast.getName());
                    ProgData.getInstance().pEventHandler.notifyListener(new P2Event(PEvents.EVENT_PARSE_PODCAST, "", ++count));
                    ParseRss.parse(ParserThread.this.progData, podcast);
                }
                if (ProgData.auto && ParserThread.this.progData.downloadList.isEmpty()) {
                    ProgQuitFactory.quit();
                    return;
                }
                if (!ParserThread.this.andStartDownload || ParserThread.this.progData.downloadList.isEmpty()) {
                    return;
                }
                P2Log.sysLog("Downloads: " + ParserThread.this.progData.downloadList.getSize() + ", jetzt noch starten");
                DownloadFactory.startAllDownloads();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void stopParser() {
            this.stop = true;
        }
    }
}

