/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.controller.parser;

import com.rometools.rome.feed.synd.SyndContent;
import com.rometools.rome.feed.synd.SyndEnclosure;
import com.rometools.rome.feed.synd.SyndEnclosureImpl;
import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.io.SyndFeedInput;
import com.rometools.rome.io.XmlReader;
import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.download.DownloadData;
import de.p2tools.p2podder.controller.data.download.DownloadFactory;
import de.p2tools.p2podder.controller.data.download.DownloadListFactory;
import de.p2tools.p2podder.controller.data.podcast.Podcast;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom2.Element;

public class ParseRss {
    static final Pattern pImg = Pattern.compile("<img[^>]*src=\"[^\"]*\"[^>]*>", 2);

    private ParseRss() {
    }

    /*
     * WARNING - void declaration
     */
    public static void parse(ProgData progData, Podcast podcast) {
        try {
            URL feedUrl = new URL(podcast.getUrl());
            SyndFeedInput input = new SyndFeedInput();
            SyndFeed syndFeed = input.build(new XmlReader(feedUrl));
            ArrayList<DownloadData> downloads = new ArrayList<DownloadData>();
            List<SyndEntry> entries = syndFeed.getEntries();
            for (SyndEntry syndEntry : entries) {
                void var22_24;
                int days;
                String author = syndEntry.getAuthor();
                String title = syndEntry.getTitle();
                String uri = syndEntry.getUri();
                String website = syndEntry.getLink();
                String pubDate = syndEntry.getPublishedDate().toString();
                String duration = "";
                SyndContent desc = syndEntry.getDescription();
                List<Element> foreignMarkup = syndEntry.getForeignMarkup();
                for (Element element : foreignMarkup) {
                    if (!element.getName().equals("duration")) continue;
                    duration = element.getValue();
                }
                String description = "";
                if (desc != null) {
                    description = desc.getValue();
                    description = ParseRss.cleanDescription(description);
                }
                long size = 0L;
                List<SyndEnclosure> enclosures = syndEntry.getEnclosures();
                if (enclosures != null) {
                    for (SyndEnclosureImpl syndEnclosureImpl : enclosures) {
                        if (null == syndEnclosureImpl) continue;
                        uri = syndEnclosureImpl.getUrl();
                        size = syndEnclosureImpl.getLength();
                        break;
                    }
                }
                try {
                    LocalDate localDate = LocalDate.parse(pubDate, DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US));
                    days = (int)ChronoUnit.DAYS.between(localDate, LocalDate.now());
                }
                catch (Exception ex) {
                    LocalDate localDate = LocalDate.now();
                    days = 0;
                }
                if (podcast.getMaxAge() != 0 && days > podcast.getMaxAge()) continue;
                DownloadData download = new DownloadData(uri, title, website, (LocalDate)var22_24, description, podcast);
                download.getDownloadSize().setTargetSize(size);
                download.durationIntProperty().set(DownloadFactory.getDuration(duration));
                downloads.add(download);
            }
            if (!downloads.isEmpty()) {
                DownloadListFactory.addNewDownloads(downloads);
            }
        }
        catch (Exception ex) {
            P2Log.errorLog(897451209, ex.getMessage());
        }
    }

    private static String cleanDescription(String description) {
        String ret = description;
        Matcher m = pImg.matcher(ret);
        while (m.find()) {
            ret = m.replaceAll("");
        }
        ret = ret.replaceAll("<br/>", P2LibConst.LINE_SEPARATOR);
        ret = ret.replaceAll("<br />", P2LibConst.LINE_SEPARATOR);
        ret = ret.replaceAll("<BR/>", P2LibConst.LINE_SEPARATOR);
        ret = ret.replaceAll("<BR />", P2LibConst.LINE_SEPARATOR);
        ret = ret.replaceAll("<p>", "");
        ret = ret.replaceAll("</p>", "");
        ret = ret.replaceAll("Direkter Link zur Audiodatei", "");
        ret = ret.replaceAll("\\<.*?>", "");
        while (ret.startsWith(P2LibConst.LINE_SEPARATOR)) {
            ret = ret.replaceFirst(P2LibConst.LINE_SEPARATOR, "");
        }
        ret = ret.trim();
        return ret;
    }
}

