/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.controller.filter;

import de.p2tools.p2lib.colordata.P2ColorData;
import de.p2tools.p2podder.controller.filter.Filter;
import javafx.application.Platform;
import javafx.scene.control.TextField;
import javafx.scene.paint.Color;

public class FilterCheckRegEx {
    private static final P2ColorData FILTER_REGEX = new P2ColorData("COLOR_FILTER_REGEX", Color.rgb(206, 255, 202), Color.rgb(79, 129, 74));
    private static final P2ColorData FILTER_REGEX_ERROR = new P2ColorData("COLOR_FILTER_REGEX_ERROR", Color.rgb(255, 230, 230), Color.rgb(170, 0, 0));
    private final int COUNTER_MAX = 2500;
    private TextField tf;
    private boolean colorRed = false;
    private int counter = 0;
    private ColorThread colorThread = null;

    public FilterCheckRegEx(TextField tf) {
        this.tf = tf;
        this.checkPattern();
    }

    public void checkPattern() {
        String text = this.tf.getText();
        if (!Filter.isPattern(text)) {
            this.colorRed = false;
            this.tf.setStyle("");
        } else {
            if (Filter.makePattern(text) == null) {
                this.colorRed = true;
                this.tf.setStyle("");
                this.tf.setStyle("-fx-control-inner-background: " + FILTER_REGEX_ERROR.getColorLightToWeb() + ";");
            } else {
                this.colorRed = false;
                this.tf.setStyle("");
                this.tf.setStyle("-fx-control-inner-background: " + FILTER_REGEX.getColorLightToWeb() + ";");
            }
            if (this.colorThread != null) {
                this.counter = 2500;
            } else {
                this.colorThread = new ColorThread();
                this.colorThread.start();
            }
        }
    }

    private class ColorThread
    extends Thread {
        public ColorThread() {
            this.setName("ColorThread");
            FilterCheckRegEx.this.counter = 2500;
        }

        @Override
        public void run() {
            try {
                while (FilterCheckRegEx.this.counter > 0) {
                    FilterCheckRegEx.this.counter -= 500;
                    ColorThread.sleep(500L);
                }
                if (!FilterCheckRegEx.this.colorRed) {
                    Platform.runLater(() -> FilterCheckRegEx.this.tf.setStyle(""));
                }
                FilterCheckRegEx.this.colorThread = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

