/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.controller.filter;

import java.util.regex.Pattern;

public class Filter {
    public String filter = "";
    public String[] filterArr = new String[]{""};
    public boolean filterAnd = false;
    public boolean exact = false;
    public Pattern pattern = null;
    public boolean empty = true;

    public Filter() {
    }

    public Filter(String filter, boolean makeArr) {
        this.filter = filter;
        this.filterArr = new String[]{filter};
        if (makeArr) {
            this.makeFilterArray();
        } else {
            this.makeFilter();
        }
    }

    public Filter(String filter, boolean exact, boolean makeArr) {
        this.filter = filter;
        this.filterArr = new String[]{filter};
        this.exact = exact;
        if (makeArr) {
            this.makeFilterArray();
        } else {
            this.makeFilter();
        }
    }

    public void makeFilter() {
        if (this.filter.isEmpty()) {
            this.filterArr = new String[]{""};
            this.pattern = null;
            this.empty = true;
            return;
        }
        this.empty = false;
        this.pattern = Filter.makePattern(this.filter);
        this.filterArr = this.exact || this.pattern != null ? new String[]{this.filter} : new String[]{this.filter.trim().toLowerCase()};
        this.checkArray();
    }

    public void makeFilterArray() {
        if (this.filter.isEmpty()) {
            this.filterArr = new String[]{""};
            this.pattern = null;
            this.empty = true;
            return;
        }
        this.empty = false;
        this.pattern = Filter.makePattern(this.filter);
        if (this.exact || this.pattern != null) {
            this.filterArr = new String[]{this.filter};
        } else {
            if (this.filter.contains(":")) {
                this.filterAnd = true;
                this.filterArr = this.filter.split(":");
            } else {
                this.filterAnd = false;
                this.filterArr = this.filter.split(",");
            }
            for (int i = 0; i < this.filterArr.length; ++i) {
                this.filterArr[i] = this.filterArr[i].trim().toLowerCase();
            }
        }
        this.checkArray();
    }

    private void checkArray() {
        if (this.filterArr == null || this.filterArr.length == 0) {
            this.filterArr = new String[]{""};
            this.pattern = null;
            this.empty = true;
        }
    }

    public static Pattern makePattern(String filter) {
        Pattern p = null;
        try {
            if (Filter.isPattern(filter)) {
                p = Pattern.compile(filter.substring(2), 98);
            }
        }
        catch (Exception ex) {
            p = null;
        }
        return p;
    }

    public static boolean isPattern(String searchText) {
        return searchText.startsWith("#:");
    }
}

