/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.controller.filter;

import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.episode.Episode;
import de.p2tools.p2podder.controller.data.episode.EpisodeFactory;
import de.p2tools.p2podder.controller.filter.EpisodeFilterForwardBackward;
import de.p2tools.p2podder.controller.filter.EpisodeFilterProps;
import de.p2tools.p2podder.controller.filter.Filter;
import de.p2tools.p2podder.controller.filter.FilterCheck;
import java.util.function.Predicate;

public class EpisodeFilter
extends EpisodeFilterProps {
    private EpisodeFilterForwardBackward episodeFilterForwardBackward = null;

    public EpisodeFilter() {
        new EpisodeFilter(false);
    }

    public EpisodeFilter(boolean init) {
        if (init) {
            this.episodeFilterForwardBackward = new EpisodeFilterForwardBackward(this);
            this.initFilter();
        }
    }

    public void clearFilter() {
        this.setPodcastId(0L);
        this.setGenre("");
        this.setTitle("");
        this.setDescription("");
        this.setTimeRange(0);
        this.setDurationMin(0);
        this.setDurationMax(100);
    }

    public EpisodeFilterForwardBackward getEpisodeFilterForwardBackward() {
        return this.episodeFilterForwardBackward;
    }

    private void initFilter() {
        this.podcastIdProperty().addListener(l -> this.setPredicate());
        this.genreProperty().addListener(l -> this.setPredicate());
        this.titleProperty().addListener(l -> this.setPredicate());
        this.descriptionProperty().addListener(l -> this.setPredicate());
        this.timeRangeProperty().addListener(l -> this.setPredicate());
        this.durationMinProperty().addListener(l -> this.setPredicate());
        this.durationMaxProperty().addListener(l -> this.setPredicate());
        this.isAllProperty().addListener(l -> this.setPredicate());
        this.isNewProperty().addListener(l -> this.setPredicate());
        this.isStartetProperty().addListener(l -> this.setPredicate());
        this.isRunningProperty().addListener(l -> this.setPredicate());
        this.wasShownProperty().addListener(l -> this.setPredicate());
    }

    private void setPredicate() {
        this.setPredicate(true);
    }

    public void setPredicate(boolean setInForwardBackward) {
        if (setInForwardBackward) {
            this.episodeFilterForwardBackward.addNewFilter();
        }
        ProgData.getInstance().episodeList.filteredListSetPred(this.getPredicateEpisode());
    }

    private Predicate<Episode> getPredicateEpisode() {
        Predicate<Episode> predicate = episode -> true;
        Filter fTitle = new Filter(this.getTitle(), true);
        Filter fDescription = new Filter(this.getDescription(), true);
        if (this.getPodcastId() > 0L) {
            predicate = predicate.and(episode -> episode.podcastIdProperty().getValue().equals(this.getPodcastId()));
        }
        if (this.getGenre() != null && !this.getGenre().isEmpty()) {
            predicate = predicate.and(episode -> episode.genreProperty().getValue().equals(this.getGenre()));
        }
        if (!fTitle.empty) {
            predicate = predicate.and(episode -> FilterCheck.checkString(fTitle, episode.getEpisodeTitle()));
        }
        if (!fDescription.empty) {
            predicate = predicate.and(episode -> FilterCheck.checkString(fDescription, episode.getDescription()));
        }
        if (this.getTimeRange() != 0) {
            predicate = predicate.and(episode -> episode.checkDays(this.getTimeRange()));
        }
        if (this.getDurationMin() != 0) {
            predicate = predicate.and(episode -> episode.checkDurationMin(this.getDurationMin()));
        }
        if (this.getDurationMax() != 100) {
            predicate = predicate.and(episode -> episode.checkDurationMax(this.getDurationMax()));
        }
        if (this.isIsNew()) {
            predicate = predicate.and(Episode::isNew);
        }
        if (this.isIsStartet()) {
            predicate = predicate.and(EpisodeFactory::episodeIsStarted);
        }
        if (this.isIsRunning()) {
            predicate = predicate.and(EpisodeFactory::episodeIsRunning);
        }
        if (this.isWasShown()) {
            predicate = predicate.and(episode -> ProgData.getInstance().historyEpisodes.checkIfUrlAlreadyIn(episode.getEpisodeUrl()));
        }
        return predicate;
    }
}

