/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.controller.data.podcast;

import de.p2tools.p2lib.configfile.pdata.P2DataList;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2podder.controller.data.podcast.Podcast;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.SimpleTimeZone;
import java.util.function.Predicate;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;

public class PodcastList
extends SimpleListProperty<Podcast>
implements P2DataList<Podcast> {
    public static final String TAG = "podcastList:PodcastList";
    private static final String DATE_TIME_FORMAT = "dd.MM.yyyy, HH:mm";
    private static final SimpleDateFormat sdfUtc = new SimpleDateFormat("dd.MM.yyyy, HH:mm");
    private static final SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy, HH:mm");
    public int nr;
    public String[] genres;
    private FilteredList<Podcast> filteredList;
    private SortedList<Podcast> sortedList;
    private ObservableList<String> genreList;
    int countDouble;

    public PodcastList() {
        super(FXCollections.observableArrayList());
        sdfUtc.setTimeZone(new SimpleTimeZone(2, "UTC"));
        this.nr = 1;
        this.genres = new String[]{""};
        this.filteredList = null;
        this.sortedList = null;
        this.genreList = FXCollections.observableArrayList();
        this.countDouble = 0;
    }

    @Override
    public String getTag() {
        return TAG;
    }

    @Override
    public String getComment() {
        return "Liste aller Podcasts";
    }

    @Override
    public Podcast getNewItem() {
        return new Podcast();
    }

    @Override
    public void addNewItem(Object obj) {
        if (obj.getClass().equals(Podcast.class)) {
            this.importPodcastOnlyWithNo((Podcast)obj);
        }
    }

    public void addNewItem(List<Podcast> podcastList) {
        for (Podcast p : podcastList) {
            this.importPodcastOnlyWithNo(p);
        }
    }

    public synchronized void initList() {
        P2Duration.counterStart("initList");
        this.createFilterLists();
        this.genGenreList();
        this.addListener((ObservableValue<? super ObservableList<E>> v, ? super ObservableList<E> o, ? super ObservableList<E> n) -> this.genGenreList());
        P2Duration.counterStop("initList");
    }

    public boolean podcastExistsAlready(Podcast podcast) {
        for (Podcast podcast2 : this) {
        }
        return false;
    }

    public synchronized SortedList<Podcast> getSortedList() {
        if (this.sortedList == null || this.filteredList == null) {
            this.filteredList = new FilteredList<Podcast>(this, p -> true);
            this.sortedList = new SortedList<Podcast>((ObservableList<Podcast>)this.filteredList);
        }
        return this.sortedList;
    }

    public synchronized FilteredList<Podcast> getFilteredList() {
        if (this.sortedList == null || this.filteredList == null) {
            this.filteredList = new FilteredList<Podcast>(this, p -> true);
            this.sortedList = new SortedList<Podcast>((ObservableList<Podcast>)this.filteredList);
        }
        return this.filteredList;
    }

    public synchronized void filteredListSetPred(Predicate<Podcast> predicate) {
        this.filteredList.setPredicate(predicate);
    }

    public synchronized boolean importPodcastOnlyWithNo(Podcast podcast) {
        podcast.setNo(this.nr++);
        return super.add(podcast);
    }

    public synchronized int markStations() {
        HashSet urlHashSet = new HashSet(this.size(), 0.75f);
        P2Duration.counterStart("Podcast markieren");
        try {
            this.countDouble = 0;
            this.stream().forEach(station -> {
                if (!urlHashSet.add(station.getUrl())) {
                    ++this.countDouble;
                }
            });
        }
        catch (Exception ex) {
            P2Log.errorLog(951024789, ex);
        }
        P2Duration.counterStop("Podcast markieren");
        urlHashSet.clear();
        return this.countDouble;
    }

    @Override
    public synchronized void clear() {
        this.nr = 1;
        super.clear();
    }

    public synchronized void sort() {
        Collections.sort(this);
        int i = 1;
        for (Podcast podcast : this) {
            podcast.setNo(i++);
        }
    }

    public synchronized Podcast getPodcastById(Long id) {
        Optional<Podcast> opt = this.stream().filter(station -> station.getId() == id.longValue()).findAny();
        return opt.orElse(null);
    }

    public synchronized boolean removePodcast(Podcast podcast) {
        return this.remove(podcast);
    }

    public synchronized boolean removePodcast(List<Podcast> podcast) {
        return this.removeAll((Collection<?>)podcast);
    }

    public synchronized void removeAllPodcast() {
        this.clear();
    }

    public synchronized void createFilterLists() {
        P2Duration.counterStart("Filter-Listen suchen");
        LinkedHashSet<String> hashSet = new LinkedHashSet<String>(21);
        hashSet.add("");
        this.stream().forEach(podcast -> {
            String[] genreArr;
            for (String s : genreArr = podcast.getGenre().split(",")) {
                hashSet.add(s);
            }
        });
        this.genres = hashSet.toArray(new String[hashSet.size()]);
        P2Duration.counterStop("Filter-Listen suchen");
    }

    public synchronized ObservableList<String> getGenreList() {
        return this.genreList;
    }

    private synchronized void genGenreList() {
        P2Log.sysLog("PodcastList: genGenreList");
        LinkedHashSet hashSet = new LinkedHashSet(10);
        ArrayList arrayList = new ArrayList();
        this.stream().forEach(episode -> {
            String podcastName = episode.getGenre();
            if (!hashSet.contains(podcastName)) {
                hashSet.add(podcastName);
                arrayList.add(podcastName);
            }
        });
        this.genreList.setAll(arrayList);
    }
}

