/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.controller.data.download;

import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.download.DownloadData;
import java.util.ArrayList;
import java.util.Collection;

public class DownloadListStartStopFactory {
    private DownloadListStartStopFactory() {
    }

    public static synchronized boolean putBackDownloads() {
        ArrayList<DownloadData> list = ProgData.getInstance().downloadGui.getDownloadGuiController().getSelList();
        if (list == null || list.isEmpty()) {
            return false;
        }
        return DownloadListStartStopFactory.putBackDownloads(list);
    }

    public static synchronized boolean putBackDownloads(ArrayList<DownloadData> list) {
        boolean found = false;
        if (list == null || list.isEmpty()) {
            return false;
        }
        ProgData.getInstance().downloadStarterFactory.setPaused();
        for (DownloadData download : list) {
            if (download.isStateInit() || download.isStateStopped()) {
                download.putBack();
                found = true;
                continue;
            }
            list.remove(download);
        }
        if (found) {
            ProgData.getInstance().downloadList.removeAll((Collection<?>)list);
        }
        return found;
    }

    public static synchronized void delDownloads(DownloadData download) {
        ArrayList<DownloadData> list = new ArrayList<DownloadData>();
        list.add(download);
        DownloadListStartStopFactory.delDownloads(list);
    }

    public static synchronized boolean delDownloads(ArrayList<DownloadData> list) {
        P2Duration.counterStart("delDownloads");
        if (list == null || list.isEmpty()) {
            return false;
        }
        ProgData.getInstance().downloadStarterFactory.setPaused();
        ArrayList<DownloadData> historyList = new ArrayList<DownloadData>();
        for (DownloadData download2 : list) {
            historyList.add(download2);
        }
        if (!historyList.isEmpty()) {
            ProgData.getInstance().historyDownloads.addDownloadDataListToHistory(historyList);
        }
        list.stream().filter(download -> download.isStateStartedRun()).forEach(download -> download.stopDownload());
        boolean found = ProgData.getInstance().downloadList.removeAll((Collection<?>)list);
        P2Duration.counterStop("delDownloads");
        return found;
    }

    public static synchronized boolean stopDownloads() {
        boolean found = false;
        if (ProgData.getInstance().downloadList.isEmpty()) {
            return false;
        }
        ProgData.getInstance().downloadStarterFactory.setPaused();
        for (DownloadData download : ProgData.getInstance().downloadList) {
            if (!download.isStateStartedWaiting() && !download.isStateStartedRun() && !download.isStateError()) continue;
            download.stopDownload();
            found = true;
        }
        return found;
    }

    private static P2Alert.BUTTON restartDownload(int size, String title, P2Alert.BUTTON answer) {
        if (answer.equals((Object)P2Alert.BUTTON.UNKNOWN)) {
            String text = size > 1 ? "Es sind auch fehlerhafte Filme dabei," + P2LibConst.LINE_SEPARATOR + "diese nochmal starten?" : "Film nochmal starten?  ==> " + title;
            new P2Alert();
            answer = P2Alert.showAlert_yes_no_cancel("Download", "Fehlerhafte Downloads", text);
        }
        return answer;
    }

    public static void startDownloads(DownloadData download) {
        ArrayList<DownloadData> list = new ArrayList<DownloadData>();
        list.add(download);
        DownloadListStartStopFactory.start(list);
    }

    public static boolean startDownloads(Collection<DownloadData> list, boolean alsoFinished) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        P2Duration.counterStart("startDownloads");
        ArrayList<DownloadData> listStartDownloads = new ArrayList<DownloadData>();
        ProgData.getInstance().downloadStarterFactory.setPaused();
        list.stream().filter(download -> download.isNotStarted()).forEach(download -> listStartDownloads.add((DownloadData)download));
        if (alsoFinished && !DownloadListStartStopFactory.startAlsoFinishedDownloads(list, listStartDownloads)) {
            return false;
        }
        DownloadListStartStopFactory.start(listStartDownloads);
        P2Duration.counterStop("startDownloads");
        return true;
    }

    private static void start(ArrayList<DownloadData> downloads) {
        if (downloads.isEmpty()) {
            return;
        }
        downloads.forEach(DownloadData::initStartDownload);
        ProgData.getInstance().downloadStarterFactory.startWaitingDownloads();
    }

    private static boolean startAlsoFinishedDownloads(Collection<DownloadData> list, ArrayList<DownloadData> listStartDownloads) {
        P2Alert.BUTTON answer = P2Alert.BUTTON.UNKNOWN;
        ArrayList<DownloadData> listDelDownloads = new ArrayList<DownloadData>();
        ArrayList<DownloadData> listDownloadsRemovePodcastHistory = new ArrayList<DownloadData>();
        block4: for (DownloadData download2 : list) {
            if (download2.isStateStopped()) {
                listDelDownloads.add(download2);
                listDownloadsRemovePodcastHistory.add(download2);
                listStartDownloads.add(download2);
            }
            if (!download2.isStateError()) continue;
            if (answer.equals((Object)P2Alert.BUTTON.UNKNOWN)) {
                answer = DownloadListStartStopFactory.restartDownload(list.size(), download2.getEpisodeTitle(), answer);
            }
            switch (answer) {
                case CANCEL: {
                    continue block4;
                }
                case NO: {
                    continue block4;
                }
            }
            listDelDownloads.add(download2);
            listDownloadsRemovePodcastHistory.add(download2);
            listStartDownloads.add(download2);
        }
        if (answer.equals((Object)P2Alert.BUTTON.CANCEL)) {
            return false;
        }
        ProgData.getInstance().historyDownloads.removeDownloadDataFromHistory(listDownloadsRemovePodcastHistory);
        listDelDownloads.stream().forEach(download -> download.stopDownload());
        return true;
    }
}

