/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.controller.data.download;

import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.download.DownloadData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;

public class DownloadListFactory {
    private static boolean found = false;

    private DownloadListFactory() {
    }

    public static synchronized long countRunningDownloads() {
        return ProgData.getInstance().downloadList.stream().filter(DownloadData::isStarted).count();
    }

    public static synchronized void addNewDownloads(ArrayList<DownloadData> list) {
        Set syncDownloadsAlreadyInTheListHash = Collections.synchronizedSet(new HashSet(150));
        ProgData.getInstance().downloadList.forEach(download -> syncDownloadsAlreadyInTheListHash.add(download.getEpisodeUrl()));
        found = false;
        List<DownloadData> syncDownloadArrayList = Collections.synchronizedList(new ArrayList());
        list.stream().filter(download -> !ProgData.getInstance().historyDownloads.checkIfUrlAlreadyIn(download.getEpisodeUrl())).forEach(download -> {
            String urlDownload = download.getEpisodeUrl();
            if (!syncDownloadsAlreadyInTheListHash.add(urlDownload)) {
                return;
            }
            syncDownloadArrayList.add((DownloadData)download);
            found = true;
        });
        if (found) {
            DownloadListFactory.checkDoubleNames(syncDownloadArrayList, ProgData.getInstance().downloadList);
            ProgData.getInstance().downloadList.addAll((Collection<? extends DownloadData>)syncDownloadArrayList);
        }
        syncDownloadArrayList.clear();
        syncDownloadsAlreadyInTheListHash.clear();
    }

    public static void checkDoubleNames(List<DownloadData> foundDownloads, List<DownloadData> downloadList) {
        try {
            ArrayList alreadyDone = new ArrayList();
            foundDownloads.stream().forEach(download -> {
                String oldName;
                String newName = oldName = download.getDestFileName();
                int i = 1;
                while (DownloadListFactory.searchName(downloadList, newName) || DownloadListFactory.searchName(alreadyDone, newName)) {
                    newName = DownloadListFactory.getNewName(oldName, ++i);
                }
                if (!oldName.equals(newName)) {
                    download.setDestFileName(newName);
                }
                alreadyDone.add(download);
            });
        }
        catch (Exception ex) {
            P2Log.errorLog(303021458, ex);
        }
    }

    private static String getNewName(String oldName, int i) {
        String base = FilenameUtils.getBaseName(oldName);
        String suff = FilenameUtils.getExtension(oldName);
        return base + "_" + i + "." + suff;
    }

    private static boolean searchName(List<DownloadData> searchDownloadList, String name) {
        return searchDownloadList.stream().filter(download -> download.getDestFileName().equals(name)).findAny().isPresent();
    }
}

