/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.controller.data.download;

import de.p2tools.p2lib.configfile.pdata.P2DataList;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.download.DownloadData;
import de.p2tools.p2podder.controller.data.download.DownloadListStartStopFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.function.Predicate;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;

public class DownloadList
extends SimpleListProperty<DownloadData>
implements P2DataList<DownloadData> {
    public static final String TAG = "downloadList:DownloadList";
    private final ProgData progData;
    private int no = 0;
    private boolean found = false;
    private final FilteredList<DownloadData> filteredList;
    private final SortedList<DownloadData> sortedList;
    private final BooleanProperty downloadsChanged = new SimpleBooleanProperty(true);
    private final ObservableList<String> genreList = FXCollections.observableArrayList();

    public DownloadList(ProgData progData) {
        super(FXCollections.observableArrayList());
        this.progData = progData;
        this.filteredList = new FilteredList<DownloadData>(this, p -> true);
        this.sortedList = new SortedList<DownloadData>((ObservableList<DownloadData>)this.filteredList);
    }

    @Override
    public String getTag() {
        return TAG;
    }

    @Override
    public String getComment() {
        return "Liste aller Downloads";
    }

    @Override
    public DownloadData getNewItem() {
        return new DownloadData();
    }

    @Override
    public void addNewItem(Object obj) {
        if (obj.getClass().equals(DownloadData.class)) {
            DownloadData d = (DownloadData)obj;
            this.add(d);
        }
    }

    public synchronized void initList() {
        P2Duration.counterStart("initList");
        for (DownloadData download : this) {
            download.setPodcast(this.progData.podcastList.getPodcastById(download.getPodcastId()));
            download.setGuiState(download.getState());
        }
        this.genGenreList();
        this.addListener((ObservableValue<? super ObservableList<E>> v, ? super ObservableList<E> o, ? super ObservableList<E> n) -> this.genGenreList());
        P2Duration.counterStop("initList");
    }

    public SortedList<DownloadData> getSortedList() {
        return this.sortedList;
    }

    public synchronized void filteredListSetPred(Predicate<DownloadData> predicate) {
        this.filteredList.setPredicate(predicate);
    }

    public void sort() {
        Collections.sort(this);
    }

    @Override
    public synchronized boolean add(DownloadData d) {
        d.setNo(++this.no);
        return super.add(d);
    }

    @Override
    public synchronized boolean addAll(Collection<? extends DownloadData> elements) {
        elements.forEach(f -> f.setNo(++this.no));
        return super.addAll(elements);
    }

    public boolean addAll(DownloadData ... var1) {
        for (DownloadData f : var1) {
            f.setNo(++this.no);
        }
        return super.addAll(var1);
    }

    public synchronized boolean remove(DownloadData objects) {
        return super.remove(objects);
    }

    @Override
    public synchronized boolean removeAll(Collection<?> objects) {
        return super.removeAll(objects);
    }

    public synchronized void putBackDownloads(DownloadData download) {
        ArrayList<DownloadData> list = new ArrayList<DownloadData>();
        list.add(download);
        if (DownloadListStartStopFactory.putBackDownloads(list)) {
            this.setDownloadsChanged();
        }
    }

    public void startDownloads(Collection<DownloadData> list, boolean alsoFinished) {
        if (DownloadListStartStopFactory.startDownloads(list, alsoFinished)) {
            this.setDownloadsChanged();
        }
    }

    public void startDownloads(DownloadData download) {
        DownloadListStartStopFactory.startDownloads(download);
        this.setDownloadsChanged();
    }

    public void stopAllDownloads() {
        DownloadListStartStopFactory.stopDownloads();
        this.setDownloadsChanged();
    }

    synchronized void setDownloadsChanged() {
        this.downloadsChanged.set(!this.downloadsChanged.get());
    }

    public synchronized ObservableList<String> getGenreList() {
        return this.genreList;
    }

    public synchronized void genGenreList() {
        P2Log.sysLog("DownloadList: genGenreList");
        LinkedHashSet hashSet = new LinkedHashSet(10);
        ArrayList arrayList = new ArrayList();
        this.stream().forEach(download -> {
            String podcastName = download.getGenre();
            if (!hashSet.contains(podcastName)) {
                hashSet.add(podcastName);
                arrayList.add(podcastName);
            }
        });
        this.genreList.setAll(arrayList);
    }
}

