/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.controller.data.download;

import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.file.P2FileUtils;
import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.download.DownloadData;
import de.p2tools.p2podder.controller.data.download.DownloadList;
import de.p2tools.p2podder.controller.data.episode.Episode;
import de.p2tools.p2podder.controller.data.podcast.Podcast;
import de.p2tools.p2podder.gui.dialog.DownloadFileDelDialogController;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DownloadFactory {
    public static synchronized void startAllDownloads() {
        DownloadList downloadList = ProgData.getInstance().downloadList;
        downloadList.forEach(d -> ProgData.getInstance().downloadList.startDownloads(downloadList, false));
    }

    public static synchronized void cleanUpList() {
        boolean found = false;
        Iterator it = ProgData.getInstance().downloadList.iterator();
        while (it.hasNext()) {
            DownloadData download = (DownloadData)it.next();
            if (download.isStateInit() || download.isStateStopped()) continue;
            if (download.isStateFinished()) {
                it.remove();
                found = true;
                continue;
            }
            if (!download.isStateError()) continue;
            download.resetDownload();
            found = true;
        }
        if (found) {
            ProgData.getInstance().downloadList.setDownloadsChanged();
        }
    }

    public static void cleanUpDownloadDir() {
        File destDir = new File(ProgConfig.SYSTEM_POD_DIR.getValueSafe());
        if (!destDir.exists()) {
            P2Alert.showInfoAlert("Downloads aufr\u00e4umen", "Dateien ohne Episode suchen", "Das Verzeichnis mit den Downloads existiert nicht!");
            return;
        }
        ArrayList fileList = new ArrayList();
        ArrayList<File> delList = new ArrayList<File>();
        try (Stream<Path> walk = Files.walk(destDir.toPath(), new FileVisitOption[0]);){
            fileList.addAll(walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(path -> path.toFile()).collect(Collectors.toList()));
        }
        catch (IOException e) {
            P2Log.errorLog(456201247, e);
        }
        for (File file : fileList) {
            boolean found = false;
            for (Episode episode : ProgData.getInstance().episodeList) {
                String fPath;
                String ePath = P2FileUtils.addsPath(episode.getFilePath(), episode.getFileName());
                if (!ePath.equals(fPath = file.getPath())) continue;
                found = true;
                break;
            }
            if (found) continue;
            delList.add(file);
        }
        if (delList.isEmpty()) {
            P2Alert.showInfoAlert("Downloads aufr\u00e4umen", "Dateien ohne Episode suchen", "Es wurden keine Dateien ohne passende Episode, gefunden.");
            return;
        }
        DownloadFileDelDialogController downloadFileDelDialogController = new DownloadFileDelDialogController(ProgData.getInstance(), delList);
        if (downloadFileDelDialogController.isOk()) {
            delList.stream().forEach(delFile -> {
                try {
                    if (delFile.exists()) {
                        P2Log.sysLog("Episode (Datei) l\u00f6schen: " + delFile.getAbsolutePath());
                        if (!delFile.delete()) {
                            throw new Exception();
                        }
                    }
                }
                catch (Exception ex) {
                    P2Alert.showInfoAlert("Downloads aufr\u00e4umen", "Dateien ohne Episode suchen", "Das l\u00f6schen der Datei: " + P2LibConst.LINE_SEPARATOR + delFile.getAbsolutePath() + P2LibConst.LINE_SEPARATOR + " hat nicht geklappt!");
                    P2Log.errorLog(901254123, "Fehler beim l\u00f6schen: " + delFile.getAbsolutePath());
                }
            });
        }
    }

    public static synchronized long getDownloadsWaiting() {
        return ProgData.getInstance().downloadList.stream().filter(DownloadData::isStateStartedWaiting).count();
    }

    public static synchronized long getDownloadsSaving() {
        return ProgData.getInstance().downloadList.stream().filter(DownloadData::isStateStartedRun).count();
    }

    public static synchronized List<Podcast> getPodcastList() {
        P2Duration.counterStart("getPodcastList");
        LinkedHashSet hashSet = new LinkedHashSet(10);
        ArrayList<Podcast> arrayList = new ArrayList<Podcast>();
        ProgData.getInstance().downloadList.stream().forEach(download -> {
            String podcastName = download.getPodcastName();
            Podcast podcast = ProgData.getInstance().podcastList.getPodcastById(download.getPodcastId());
            if (podcast != null && !hashSet.contains(podcastName)) {
                hashSet.add(podcastName);
                arrayList.add(podcast);
            }
        });
        P2Duration.counterStop("getPodcastList");
        return arrayList;
    }

    public static long countDownload(Podcast podcast) {
        return ProgData.getInstance().downloadList.stream().filter(p -> p.getPodcastId() == podcast.getId()).count();
    }

    public static int getDuration(String duration) {
        int ret = 0;
        if (!duration.contains(":")) {
            try {
                ret = Integer.parseInt(duration);
            }
            catch (Exception exception) {}
        } else {
            try {
                String last;
                if (duration.contains(":")) {
                    last = duration.substring(duration.lastIndexOf(":") + 1);
                    duration = duration.substring(0, duration.lastIndexOf(":"));
                } else {
                    last = duration;
                    duration = "";
                }
                int d = Integer.parseInt(last);
                ret += d;
                if (!duration.isEmpty()) {
                    if (duration.contains(":")) {
                        last = duration.substring(duration.lastIndexOf(":") + 1);
                        duration = duration.substring(0, duration.lastIndexOf(":"));
                    } else {
                        last = duration;
                        duration = "";
                    }
                    d = Integer.parseInt(last) * 60;
                    ret += d;
                }
                if (!duration.isEmpty()) {
                    last = duration.contains(":") ? duration.substring(duration.lastIndexOf(":") + 1) : duration;
                    d = Integer.parseInt(last) * 60 * 60;
                    ret += d;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }
}

