/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.controller.data.download;

import de.p2tools.p2lib.configfile.config.Config;
import de.p2tools.p2lib.mediathek.download.DownloadSize;
import de.p2tools.p2lib.tools.file.P2FileUtils;
import de.p2tools.p2lib.tools.net.PUrlTools;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.data.download.DownloadDataProps;
import de.p2tools.p2podder.controller.data.download.DownloadProgram;
import de.p2tools.p2podder.controller.data.podcast.Podcast;
import de.p2tools.p2podder.controller.starterdownload.DownloadStart;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;

public final class DownloadData
extends DownloadDataProps {
    private DownloadStart downloadStart = new DownloadStart(this);
    private String errorMessage = "";

    public DownloadData() {
    }

    public DownloadData(String episodeUri, String title, String website, LocalDate pubDate, String description, Podcast podcast) {
        this.setEpisodeUrl(episodeUri);
        this.setEpisodeTitle(title);
        this.setEpisodeWebsite(website);
        this.setPubDate(pubDate);
        this.setDescription(description);
        this.setPodcastId(podcast.getId());
        this.setPodcastName(podcast.getName());
        this.setGenre(podcast.getGenre());
        String path = P2FileUtils.addsPath(ProgConfig.SYSTEM_POD_DIR.getValueSafe(), podcast.getGenre());
        String name = PUrlTools.getFileName(episodeUri);
        DownloadProgram.makeProgParameter(this, name, path);
    }

    public DownloadStart getDownloadStart() {
        return this.downloadStart;
    }

    public void setDownloadStart(DownloadStart downloadStart) {
        this.downloadStart = downloadStart;
    }

    public void setPodcast(Podcast podcast) {
        if (podcast == null) {
            this.setPodcastName("");
            return;
        }
        this.setPodcastId(podcast.getId());
        this.setPodcastName(podcast.getName());
    }

    public void putBack() {
        this.setPlacedBack(true);
        this.resetDownload();
    }

    public void resetDownload() {
        this.stopDownload();
        this.setState(0);
    }

    public void stopDownload() {
        if (this.isStateError()) {
            this.getDownloadStart().setRestartCounter(ProgConfig.SYSTEM_PARAMETER_DOWNLOAD_MAX_RESTART.getValue());
        } else {
            this.setState(1);
            this.setProgress(-1.0);
        }
        DownloadSize downSize = this.getDownloadSize();
        downSize.resetActFileSize();
        this.setRemaining("");
        this.setBandwidth("");
        this.getDownloadStart().setBandwidth(0L);
    }

    public void initStartDownload() {
        this.getDownloadStart().setRestartCounter(0);
        this.getDownloadStart().setBandwidth(0L);
        this.setStateStartedWaiting();
        this.setErrorMessage("");
    }

    public boolean checkDays(long days) {
        if (days == 0L) {
            return true;
        }
        long timeRange = ChronoUnit.DAYS.between(this.getPubDate(), LocalDate.now());
        return timeRange <= days;
    }

    public boolean isStateInit() {
        return this.getState() == 0;
    }

    public boolean isStarted() {
        return this.getState() > 1 && !this.isStateFinished();
    }

    public boolean isNotStarted() {
        return this.getState() <= 1;
    }

    public boolean isStateStopped() {
        return this.getState() == 1;
    }

    public boolean isStateStartedWaiting() {
        return this.getState() == 2;
    }

    public boolean isStateStartedRun() {
        return this.getState() == 3;
    }

    public boolean isStateFinished() {
        return this.getState() == 4;
    }

    public boolean isStateFinalized() {
        return this.getState() >= 4;
    }

    public boolean isStateError() {
        return this.getState() == 5;
    }

    public void setStateInit() {
        this.setState(0);
    }

    public void setStateStartedWaiting() {
        this.setState(2);
    }

    public void setStateStartedRun() {
        this.setState(3);
    }

    public void setStateFinished() {
        this.setState(4);
    }

    public void setStateError() {
        this.setState(5);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        String s = "Der Download hatte einen Fehler:\n\n";
        this.errorMessage = "Der Download hatte einen Fehler:\n\n" + errorMessage;
    }

    public void restartDownload() {
        DownloadSize downSize = this.getDownloadSize();
        downSize.resetActFileSize();
        this.setRemaining("");
        this.setBandwidth("");
        this.getDownloadStart().setBandwidth(0L);
        this.setState(0);
        this.setProgress(-1.0);
    }

    public DownloadData getCopy() {
        DownloadData ret = new DownloadData();
        Config[] configs = this.getConfigsArr();
        Config[] configsCopy = ret.getConfigsArr();
        for (int i = 0; i < configs.length; ++i) {
            configsCopy[i].setActValue(configs[i].getActValueString());
        }
        ret.setGuiState(this.getGuiState());
        ret.setDownloadStart(this.getDownloadStart());
        return ret;
    }

    public void copyToMe(DownloadData download) {
        Config[] configs = download.getConfigsArr();
        Config[] configsCopy = this.getConfigsArr();
        for (int i = 0; i < configs.length; ++i) {
            configsCopy[i].setActValue(configs[i].getActValueString());
        }
        this.setGuiState(download.getGuiState());
        this.setDownloadStart(download.getDownloadStart());
    }
}

