/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.controller.data;

import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.tools.P2InfoFactory;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.data.SetData;
import de.p2tools.p2podder.controller.data.SetDataList;
import de.p2tools.p2podder.controller.starterepisode.StartRuntimeExec;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;

public class SetFactory {
    private static final ArrayList<String> winPath = new ArrayList();

    public static boolean addSetTemplate(SetDataList pSet) {
        if (pSet == null) {
            return false;
        }
        if (ProgData.getInstance().setDataList.addSetData(pSet)) {
            ProgConfig.SYSTEM_UPDATE_PROGSET_VERSION.setValue(pSet.version);
            return true;
        }
        return false;
    }

    public static boolean checkPrograms(ProgData data) {
        String PIPE = "| ";
        String LEER = "      ";
        String PFEIL = " -> ";
        boolean ret = true;
        Object text = "";
        for (SetData setData : data.setDataList) {
            if (setData.getProgSwitch().isEmpty()) {
                ret = false;
                text = (String)text + "|       Kein Programm angegeben!" + P2LibConst.LINE_SEPARATOR;
                text = (String)text + "|        -> Programmname: " + setData.getName() + P2LibConst.LINE_SEPARATOR;
                text = (String)text + "|             Pfad: " + setData.getProgSwitch() + P2LibConst.LINE_SEPARATOR;
                continue;
            }
            if (new File(setData.getProgPath()).canExecute()) continue;
            StartRuntimeExec r = new StartRuntimeExec(setData.getProgPath());
            Process pr = r.exec();
            if (pr != null) {
                pr.destroy();
                continue;
            }
            ret = false;
            text = (String)text + "|       Falscher Programmpfad!" + P2LibConst.LINE_SEPARATOR;
            text = (String)text + "|        -> Programmname: " + setData.getName() + P2LibConst.LINE_SEPARATOR;
            text = (String)text + "|             Pfad: " + setData.getProgPath() + P2LibConst.LINE_SEPARATOR;
            if (setData.getProgPath().contains(File.separator)) continue;
            text = (String)text + "|        -> Wenn das Programm nicht im Systempfad liegt, " + P2LibConst.LINE_SEPARATOR;
            text = (String)text + "|             wird der Start nicht klappen!" + P2LibConst.LINE_SEPARATOR;
        }
        P2Alert.showInfoAlert("Set", "Sets pr\u00fcfen", (String)text);
        return ret;
    }

    public static String getTemplatePathVlc() {
        String PATH_LINUX_VLC = "/usr/bin/vlc";
        String PATH_FREEBSD = "/usr/local/bin/vlc";
        String PATH_WIN = "\\VideoLAN\\VLC\\vlc.exe";
        Object path = "";
        try {
            switch (P2InfoFactory.getOs()) {
                case LINUX: {
                    if (System.getProperty("os.name").toLowerCase().contains("freebsd")) {
                        path = "/usr/local/bin/vlc";
                        break;
                    }
                    path = "/usr/bin/vlc";
                    break;
                }
                default: {
                    String s;
                    SetFactory.setWinProgPath();
                    Iterator<String> iterator2 = winPath.iterator();
                    while (iterator2.hasNext() && !new File((String)(path = (s = iterator2.next()) + "\\VideoLAN\\VLC\\vlc.exe")).exists()) {
                    }
                    break;
                }
            }
            if (!new File((String)path).exists() && System.getenv("PATH_VLC") != null) {
                path = System.getenv("PATH_VLC");
            }
            if (!new File((String)path).exists()) {
                path = "";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return path;
    }

    private static void setWinProgPath() {
        String[] PATH;
        String pfad;
        if (System.getenv("ProgramFiles") != null && new File(pfad = System.getenv("ProgramFiles")).exists() && !winPath.contains(pfad)) {
            winPath.add(pfad);
        }
        if (System.getenv("ProgramFiles(x86)") != null && new File(pfad = System.getenv("ProgramFiles(x86)")).exists() && !winPath.contains(pfad)) {
            winPath.add(pfad);
        }
        for (String s : PATH = new String[]{"C:\\Program Files", "C:\\Programme", "C:\\Program Files (x86)"}) {
            if (!new File(s).exists() || winPath.contains(s)) continue;
            winPath.add(s);
        }
    }
}

