/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.controller.data;

import de.p2tools.p2lib.tools.P2InfoFactory;
import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2podder.controller.data.SetData;
import de.p2tools.p2podder.controller.data.SetDataList;
import de.p2tools.p2podder.tools.GetFile;
import java.io.InputStreamReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class ImportSetDataFactory {
    private ImportSetDataFactory() {
    }

    public static SetDataList getStandarset() {
        SetDataList setDataList = ImportSetDataFactory.importPset(switch (P2InfoFactory.getOs()) {
            case P2InfoFactory.OperatingSystemType.LINUX -> new GetFile().getPsetTamplateLinux();
            default -> new GetFile().getPsetTemplateWindows();
        });
        if (setDataList != null) {
            SetDataList.progReplacePattern(setDataList);
        } else {
            P2Log.errorLog(956487459, "Konnte die Sets nicht anlegen!");
        }
        return setDataList;
    }

    private static SetDataList importPset(InputStreamReader in) {
        SetDataList list = new SetDataList();
        try {
            XMLInputFactory inFactory = XMLInputFactory.newInstance();
            inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
            inFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
            inFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            XMLStreamReader parser = inFactory.createXMLStreamReader(in);
            while (parser.hasNext()) {
                SetData setData;
                int event = parser.next();
                if (event != 1 || !parser.getLocalName().equals("programSet") || !ImportSetDataFactory.get(parser, "programSet", setData = new SetData()) || setData.getProgPath().isEmpty() || setData.getProgSwitch().isEmpty()) continue;
                list.add(setData);
            }
            in.close();
        }
        catch (Exception ex) {
            P2Log.errorLog(467810360, ex);
            return null;
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    private static boolean get(XMLStreamReader parser, String xmlElem, SetData setData) {
        boolean ret = true;
        try {
            int event;
            while (parser.hasNext() && ((event = parser.next()) != 2 || !parser.getLocalName().equals(xmlElem))) {
                if (event != 1) continue;
                switch (parser.getLocalName()) {
                    case "name": {
                        setData.setName(parser.getElementText());
                        break;
                    }
                    case "progPath": {
                        setData.setProgPath(parser.getElementText());
                        break;
                    }
                    case "progSwitch": {
                        setData.setProgSwitch(parser.getElementText());
                        break;
                    }
                    case "description": {
                        setData.setDescription(parser.getElementText());
                    }
                }
            }
        }
        catch (Exception ex) {
            ret = false;
            P2Log.errorLog(467256394, ex);
        }
        return ret;
    }
}

