/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2podder.controller;

import de.p2tools.p2lib.tools.P2InfoFactory;
import de.p2tools.p2lib.tools.date.P2DateConst;
import de.p2tools.p2lib.tools.date.P2LDateFactory;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2lib.tools.log.P2LogMessage;
import de.p2tools.p2podder.controller.config.ProgConfig;
import de.p2tools.p2podder.controller.config.ProgData;
import de.p2tools.p2podder.controller.config.ProgInfosFactory;
import de.p2tools.p2podder.controller.data.podcast.Podcast;
import de.p2tools.p2podder.controller.parser.ParserThread;
import de.p2tools.p2podder.gui.dialog.AutoDialog;
import de.p2tools.p2podder.tools.update.SearchProgramUpdate;
import java.util.ArrayList;
import java.util.Date;
import javafx.stage.Stage;

public class ProgStartAfterGui {
    private ProgStartAfterGui() {
    }

    public static void workAfterGui() {
        ProgStartAfterGui.startMsg();
        ProgStartAfterGui.setTitle();
        ProgData.getInstance().initProgData();
        ProgStartAfterGui.checkProgUpdate();
        ProgStartAfterGui.loadPodcastListProgStart();
    }

    private static void setTitle() {
        Stage stage = ProgData.getInstance().primaryStageBig;
        if (ProgData.debug) {
            stage.setTitle("P2Podder " + P2InfoFactory.getProgVersion() + " / DEBUG");
        } else {
            stage.setTitle("P2Podder " + P2InfoFactory.getProgVersion());
        }
    }

    public static void loadPodcastListProgStart() {
        P2Duration.onlyPing("Programmstart Podcastliste laden: start");
        if (ProgData.firstProgramStart) {
            ProgStartAfterGui.addStartPodcasts();
            return;
        }
        if (ProgData.auto) {
            P2Log.sysLog("Auto: Nach neuen Episoden suchen");
            ProgConfig.SYSTEM_UPDATE_PODCAST_DATE.setValue(P2DateConst.F_FORMAT_yyyy_MM_dd.format(new Date()));
            new ParserThread(ProgData.getInstance()).parse(ProgData.getInstance().podcastList, true);
            new AutoDialog(ProgData.getInstance());
            return;
        }
        if (ProgConfig.SYSTEM_UPDATE_PODCAST_DAILY.getValue().booleanValue()) {
            if (((String)ProgConfig.SYSTEM_UPDATE_PODCAST_DATE.get()).equals(P2DateConst.F_FORMAT_yyyy_MM_dd.format(new Date()))) {
                P2Log.sysLog("keine neuen Episoden suchen: Heute schon gemacht");
            } else {
                P2Log.sysLog("nach neuen Episoden suchen");
                ProgConfig.SYSTEM_UPDATE_PODCAST_DATE.setValue(P2DateConst.F_FORMAT_yyyy_MM_dd.format(new Date()));
                new ParserThread(ProgData.getInstance()).parse(ProgData.getInstance().podcastList, ProgConfig.SYSTEM_START_DAILY_DOWNLOAD.getValue());
            }
        } else {
            P2Log.sysLog("keine neuen Episoden suchen: Nicht gew\u00fcnscht");
        }
    }

    private static void addStartPodcasts() {
        P2Log.sysLog("############################################################");
        P2Log.sysLog("erster Programmstart, ein paar Pods eintragen");
        Podcast podcast = new Podcast();
        podcast.setName("DRadio-Europa Heute");
        podcast.setGenre("Nachrichten");
        podcast.setMaxAge(40);
        podcast.setUrl("https://www.deutschlandfunk.de/europa-heute-104.xml");
        podcast.setWebsite("https://www.deutschlandfunk.de/europa-heute-100.html");
        podcast.setDescription("In \"Europa heute\" wird unser Kontinent konkret. Unsere Reporter betrachten Alltagsph\u00e4nomene und stellen sie in den gro\u00dfen, politischen Zusammenhang. \"Europa heute\" erkl\u00e4rt und schildert.");
        ProgData.getInstance().podcastList.addNewItem(podcast);
        podcast = new Podcast();
        podcast.setName("Forschung Aktuell - Deutschlandfunk");
        podcast.setGenre("Forschung");
        podcast.setMaxAge(40);
        podcast.setUrl("https://www.deutschlandfunk.de/forschung-aktuell-104.xml");
        podcast.setWebsite("https://www.deutschlandfunk.de/forschung-aktuell-100.html");
        podcast.setDescription("T\u00e4glich das Neueste aus Naturwissenschaft, Medizin und Technik. Berichte, Reportagen und Interviews aus der Welt der Wissenschaft. Ob Astronomie, Biologie, Chemie, Geologie, \u00d6kologie, Physik oder Raumfahrt: Forschung Aktuell liefert Wissen im Kontext und Bildung mit Unterhaltungswert.");
        ProgData.getInstance().podcastList.addNewItem(podcast);
        podcast = new Podcast();
        podcast.setName("Computer und Kommunikation (komplette Sendung) - Deutschlandfunk");
        podcast.setGenre("Computer");
        podcast.setMaxAge(40);
        podcast.setUrl("https://www.deutschlandfunk.de/computer-und-kommunikation-102.xml");
        podcast.setWebsite("https://www.deutschlandfunk.de/computer-und-kommunikation-102.html");
        podcast.setDescription("Jeden Samstag das Neueste aus Computertechnik und Informationstechnologie. Beitr\u00e4ge, Reportagen und Interviews zu IT-Sicherheit, Informatik, Datenschutz, Smartphones, Cloud-Computing und IT-Politik. Die Trends der IT werden kompakt und informativ zusammengefasst.");
        ProgData.getInstance().podcastList.addNewItem(podcast);
        podcast = new Podcast();
        podcast.setName("DRadio-Umwelt und Verbraucher");
        podcast.setGenre("Umweltschutz");
        podcast.setMaxAge(40);
        podcast.setUrl("https://www.deutschlandfunk.de/umwelt-und-verbraucher-102.xml");
        podcast.setWebsite("https://www.deutschlandfunk.de/umwelt-und-verbraucher-100.html");
        podcast.setDescription("Von M\u00fclltrennung bis Klimaschutz \u2013 alles, was die Umwelt bewegt und wie sie sich ver\u00e4ndert. Dazu Informationen f\u00fcr Verbraucher. Politisch und praktisch mit viel Nutzen f\u00fcr den Alltag.");
        ProgData.getInstance().podcastList.addNewItem(podcast);
    }

    private static void startMsg() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Verzeichnisse:");
        list.add("Programmpfad: " + ProgInfosFactory.getPathJar());
        list.add("Verzeichnis Einstellungen: " + ProgInfosFactory.getSettingsDirectoryString());
        list.add("============================================================");
        list.add("");
        list.add("Programmsets:");
        list.addAll(ProgData.getInstance().setDataList.getStringListSetData());
        ProgConfig.getConfigLog(list);
        P2LogMessage.startMsg("P2Podder", list);
    }

    private static void checkProgUpdate() {
        P2Duration.onlyPing("checkProgUpdate");
        if (ProgConfig.SYSTEM_SEARCH_UPDATE.getValue().booleanValue() && !ProgStartAfterGui.isUpdateCheckTodayDone()) {
            ProgStartAfterGui.runUpdateCheck();
        } else {
            ArrayList<String> list = new ArrayList<String>(5);
            list.add("Kein Update-Check:");
            if (!ProgConfig.SYSTEM_SEARCH_UPDATE.getValue().booleanValue()) {
                list.add("  der User will nicht");
            }
            if (ProgStartAfterGui.isUpdateCheckTodayDone()) {
                list.add("  heute schon gemacht");
            }
            P2Log.sysLog(list);
        }
    }

    private static boolean isUpdateCheckTodayDone() {
        return ((String)ProgConfig.SYSTEM_SEARCH_UPDATE_TODAY_DONE.get()).equals(P2LDateFactory.getNowStringR());
    }

    private static void runUpdateCheck() {
        ProgConfig.SYSTEM_SEARCH_UPDATE_TODAY_DONE.setValue(P2LDateFactory.getNowStringR());
        new SearchProgramUpdate(ProgData.getInstance()).searchNewProgramVersion(false);
    }
}

